/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jrho;

import java.util.HashSet;
import java.util.Set;
import org.aksw.jrho.JRhoObject;
import org.aksw.jrho.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JRho {
    protected static Logger logger = LoggerFactory.getLogger(JRho.class);
    protected Set<JRhoObject> objects;
    protected Node root;

    public JRho(Set<JRhoObject> objects) {
        this.objects = objects;
        this.root = new Node(new HashSet<JRhoObject>(), this, null);
    }

    public void refine() {
        this.refine(this.root);
    }

    public void refine(Node node) {
        boolean result = this.process(node);
        if (!result) {
            return;
        }
        this.objects.parallelStream().forEach(o -> {
            if (node.getLast() != null && o.compareTo(node.getLast()) <= 0) {
                return;
            }
            Node refNode = new Node(node.getComponents(), this, (JRhoObject)o);
            this.refine(refNode);
        });
    }

    protected abstract boolean process(Node var1);
}

