/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web.servlets;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionAndType;
import org.aksw.jena_sparql_api.web.servlets.ProcessQuery;
import org.aksw.jena_sparql_api.web.servlets.StreamingOutputString;
import org.aksw.jena_sparql_api.web.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparqlEndpointBase {
    private static final Logger logger = LoggerFactory.getLogger(SparqlEndpointBase.class);
    @Context
    private HttpServletRequest req;

    @Deprecated
    public QueryExecution createQueryExecution(Query query, @Context HttpServletRequest req) {
        QueryExecutionAndType tmp = this.createQueryExecution(query.toString());
        QueryExecution result = tmp.getQueryExecution();
        return result;
    }

    public QueryExecution createQueryExecution(Query query) {
        throw new RuntimeException("Not implemented");
    }

    public QueryExecutionAndType createQueryExecution(String queryString) {
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL_11);
        QueryExecution qe = this.createQueryExecution(query);
        QueryExecutionAndType result = new QueryExecutionAndType(qe, query.getQueryType());
        return result;
    }

    public Response processQuery(HttpServletRequest req, String queryString, String format) throws Exception {
        StreamingOutput so = this.processQueryToStreaming(queryString, format);
        Response response = Response.ok((Object)so).build();
        return response;
    }

    public StreamingOutput processQueryToStreaming(String queryString, String format) throws Exception {
        QueryExecutionAndType qeAndType = this.createQueryExecution(queryString);
        StreamingOutput result = ProcessQuery.processQuery(qeAndType, format);
        return result;
    }

    @GET
    @Produces(value={"application/xml"})
    public void executeQueryXml(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        if (queryString == null) {
            StreamingOutputString so = StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)so).build());
        } else {
            this.processQueryAsync(asyncResponse, queryString, "Xml");
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void executeQueryXmlPostAsync(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        if (queryString == null) {
            StreamingOutputString so = StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
            asyncResponse.resume((Object)Response.ok((Object)so).build());
        } else {
            this.processQueryAsync(asyncResponse, queryString, "Xml");
        }
    }

    @GET
    @Produces(value={"application/json", "application/sparql-results+json"})
    public void executeQueryJson(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "Json");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/sparql-results+json"})
    public void executeQueryXmlPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "Json");
    }

    public void processQueryAsync(final AsyncResponse response, String queryString, final String format) {
        final QueryExecutionAndType qeAndType = this.createQueryExecution(queryString);
        response.register((Object)new ConnectionCallback(){

            public void onDisconnect(AsyncResponse disconnect) {
                logger.debug("Client disconnected");
                qeAndType.getQueryExecution().abort();
            }
        });
        response.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    logger.debug("Successfully completed query execution");
                } else {
                    logger.debug("Failed query execution");
                }
                qeAndType.getQueryExecution().close();
            }
        });
        ThreadUtils.start(response, new Runnable(){

            @Override
            public void run() {
                try {
                    StreamingOutput result = ProcessQuery.processQuery(qeAndType, format);
                    response.resume((Object)result);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @GET
    @Produces(value={"application/rdf+xml"})
    public void executeQueryRdfXml(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "RdfXml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/rdf+xml"})
    public void executeQueryRdfXmlPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "RdfXml");
    }

    @GET
    @Produces(value={"application/sparql-results+xml"})
    public void executeQueryResultSetXml(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "Xml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/sparql-results+xml"})
    public void executeQueryResultSetXmlPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "Text");
    }

    @GET
    @Produces(value={"text/plain"})
    public void executeQueryText(@Suspended AsyncResponse asyncResponse, @QueryParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "Text");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public void executeQueryTextPost(@Suspended AsyncResponse asyncResponse, @FormParam(value="query") String queryString) {
        this.processQueryAsync(asyncResponse, queryString, "Text");
    }
}

