/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.graph.Triple;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.utils.NodeUtils;
import org.apache.jena.riot.writer.NTriplesWriter;

public class TripleUtils {
    public static String toNTripleString(Triple triple) {
        String s = NodeUtils.toNTriplesString(triple.getSubject());
        String p = NodeUtils.toNTriplesString(triple.getPredicate());
        String o = NodeUtils.toNTriplesString(triple.getObject());
        String result = s + " " + p + " " + o + " .";
        return result;
    }

    public static Triple swap(Triple t) {
        Triple result = new Triple(t.getObject(), t.getPredicate(), t.getSubject());
        return result;
    }

    public static Set<Triple> swap(Iterable<Triple> triples) {
        HashSet<Triple> result = new HashSet<Triple>();
        for (Triple t : triples) {
            result.add(TripleUtils.swap(t));
        }
        return result;
    }

    public static String md5sum(Triple triple) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NTriplesWriter.write((OutputStream)baos, Collections.singleton(triple).iterator());
        String raw = baos.toString();
        String result = StringUtils.md5Hash((String)raw);
        return result;
    }
}

