/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GraphUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Node, Graph> indexBySubject(Graph graph) {
        Map<Node, Graph> result;
        try (ExtendedIterator it = graph.find(Node.ANY, Node.ANY, Node.ANY);){
            result = GraphUtils.indexBySubject((Iterator<Triple>)it);
        }
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Iterable<Triple> triples) {
        Map<Node, Graph> result = GraphUtils.indexBySubject(triples.iterator());
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Iterator<Triple> it) {
        HashMap<Node, Graph> result = new HashMap<Node, Graph>();
        while (it.hasNext()) {
            Triple triple = it.next();
            Node s = triple.getSubject();
            Graph graph = (Graph)result.get(s);
            if (graph == null) {
                graph = GraphFactory.createGraphMem();
                result.put(s, graph);
            }
            graph.add(triple);
        }
        return result;
    }
}

