/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;

public class CompareUtils {
    public static Set<Quad> alignActualQuads(Set<Quad> expected, Set<Quad> actual) {
        Map<Node, Graph> e = QuadPatternUtils.indexAsGraphs(expected);
        Map<Node, Graph> a = QuadPatternUtils.indexAsGraphs(actual);
        Set<Quad> result = CompareUtils.alignActualQuads(e, a);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Quad> toQuads(Node g, Graph graph) {
        HashSet<Quad> result = new HashSet<Quad>();
        try (ExtendedIterator it = graph.find(null, null, null);){
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                Quad quad = new Quad(g, t);
                result.add(quad);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Quad> toQuads(Node g, Graph graph, Map<Node, Node> subst) {
        HashSet<Quad> result = new HashSet<Quad>();
        try (ExtendedIterator it = graph.find(null, null, null);){
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                Quad tmp = new Quad(g, t);
                Quad quad = QuadUtils.copySubstitute(tmp, subst);
                result.add(quad);
            }
        }
        return result;
    }

    public static Set<Quad> alignActualQuads(Map<Node, Graph> expected, Map<Node, Graph> actual) {
        HashSet<Quad> result = new HashSet<Quad>();
        Set<Node> expectedGs = expected.keySet();
        Set<Node> actualGs = actual.keySet();
        Sets.SetView excessiveGs = Sets.difference(actualGs, expectedGs);
        Sets.SetView commonGs = Sets.intersection(expectedGs, actualGs);
        for (Node g : excessiveGs) {
            Graph graph = actual.get(g);
            Set<Quad> tmp = CompareUtils.toQuads(g, graph);
            result.addAll(tmp);
        }
        for (Node g : commonGs) {
            Graph expectedGraph = expected.get(g);
            Graph actualGraph = actual.get(g);
            Node[][] rawMapping = GraphMatcher.match((Graph)actualGraph, (Graph)expectedGraph);
            HashMap<Node, Node> mapping = new HashMap<Node, Node>();
            if (rawMapping != null) {
                for (int i = 0; i < rawMapping.length; ++i) {
                    Node source = rawMapping[i][0];
                    Node target = rawMapping[i][1];
                    mapping.put(source, target);
                }
            }
            Set<Quad> tmp = CompareUtils.toQuads(g, actualGraph, mapping);
            result.addAll(tmp);
        }
        return result;
    }
}

