/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClauseUtils {
    public static final Set<Expr> TRUE = Collections.singleton(NodeValue.TRUE);

    public static Set<Set<Expr>> filterByVars(Set<Set<Expr>> clauses, Set<Var> requiredVars) {
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : clauses) {
            Set<Var> clauseVars = ClauseUtils.getVarsMentioned(clause);
            if (!clauseVars.containsAll(requiredVars)) continue;
            result.add(clause);
        }
        return result;
    }

    public static boolean isSatisfiable(Set<Expr> clause) {
        for (Expr expr : clause) {
            Expr child;
            if (expr.equals(NodeValue.FALSE)) {
                return false;
            }
            if (!ClauseUtils.isSatisfiable(expr)) {
                return false;
            }
            if (!(expr instanceof E_LogicalNot) || !clause.contains(child = ((E_LogicalNot)expr).getArg())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSatisfiable(Expr expr) {
        Expr exprCopy = expr.copySubstitute(BindingRoot.create());
        Expr folded = ExprTransformer.transform((ExprTransform)new ExprTransformConstantFold(), (Expr)exprCopy);
        return !folded.equals(NodeValue.FALSE);
    }

    public static Set<Var> getVarsMentioned(Iterable<? extends Expr> clause) {
        HashSet<Var> result = new HashSet<Var>();
        for (Expr expr : clause) {
            result.addAll(expr.getVarsMentioned());
        }
        return result;
    }

    public static Set<Set<Expr>> applyNodeTransformSet(Set<Set<Expr>> clauses, NodeTransform nodeTransform) {
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : clauses) {
            Set<Expr> transformedClause = ClauseUtils.applyNodeTransform(clause, nodeTransform);
            result.add(transformedClause);
        }
        return result;
    }

    public static Set<Expr> applyNodeTransform(Set<Expr> clause, NodeTransform nodeTransform) {
        HashSet<Expr> result = new HashSet<Expr>();
        for (Expr expr : clause) {
            Expr transformedExpr = expr.applyNodeTransform(nodeTransform);
            result.add(transformedExpr);
        }
        return result;
    }
}

