/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.gson;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.util.Collection;
import java.util.Map;

public class ExclusionStrategyClassAndFields
implements ExclusionStrategy {
    private Multimap<Class<?>, String> classToFieldName = HashMultimap.create();
    private boolean whitelist;

    public ExclusionStrategyClassAndFields(Multimap<Class<?>, String> classToFieldName) {
        this(classToFieldName, false);
    }

    public ExclusionStrategyClassAndFields(Multimap<Class<?>, String> classToFieldName, boolean whitelist) {
        this.classToFieldName = classToFieldName;
        this.whitelist = whitelist;
    }

    public boolean shouldSkipField(FieldAttributes f) {
        String fieldName = f.getName();
        Class fieldClass = f.getDeclaringClass();
        Map map = this.classToFieldName.asMap();
        boolean result = false;
        for (Map.Entry entry : map.entrySet()) {
            Class entryClass = (Class)entry.getKey();
            Collection entryFields = (Collection)entry.getValue();
            if (!entryClass.isAssignableFrom(fieldClass) || !entryFields.contains(fieldName)) continue;
            result = true;
            break;
        }
        if (this.whitelist) {
            result = !result;
        }
        return result;
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }
}

