/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_IsBlank;
import com.hp.hpl.jena.sparql.expr.E_IsURI;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCount;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.Template;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.utils.ExprUtils;

public class CannedQueryUtils {
    private static final Var g = Var.alloc((String)"g");
    private static final Var s = Var.alloc((String)"s");
    private static final Var p = Var.alloc((String)"p");
    private static final Var o = Var.alloc((String)"o");

    public static Query spoTemplate() {
        return CannedQueryUtils.spoTemplate((Node)s, (Node)p, (Node)o);
    }

    public static Query spoTemplate(Node s, Node p, Node o) {
        Query query = QueryFactory.create();
        query.setQuerySelectType();
        Triple triple = new Triple(s, p, o);
        ElementGroup group = new ElementGroup();
        group.addTriplePattern(triple);
        query.setQueryPattern((Element)group);
        if (s.isVariable()) {
            query.getProject().add(Var.alloc((String)s.getName()));
        }
        if (p.isVariable()) {
            query.getProject().add(Var.alloc((String)p.getName()));
        }
        if (o.isVariable()) {
            query.getProject().add(Var.alloc((String)o.getName()));
        }
        return query;
    }

    public static Query spoCountTemplate() {
        return CannedQueryUtils.spoCountTemplate((Node)s, (Node)p, (Node)o);
    }

    public static Query spoCountTemplate(Node s, Node p, Node o) {
        Query query = QueryFactory.create();
        query.setQuerySelectType();
        Triple triple = new Triple(s, p, o);
        ElementGroup group = new ElementGroup();
        group.addTriplePattern(triple);
        query.setQueryPattern((Element)group);
        if (s.isVariable()) {
            query.getProject().add(Var.alloc((String)s.getName()));
        }
        if (p.isVariable()) {
            query.getProject().add(Var.alloc((String)p.getName()));
        }
        if (o.isVariable()) {
            query.getProject().add(Var.alloc((String)o.getName()));
        }
        query.allocAggregate((Aggregator)new AggCount());
        return query;
    }

    public static Query constructBySubjects(Collection<Node> ss) {
        ExprVar vs = new ExprVar(s);
        Query query = QueryFactory.create();
        query.setQueryConstructType();
        query.setDistinct(true);
        Triple triple = new Triple((Node)s, (Node)p, (Node)o);
        ElementGroup group = new ElementGroup();
        group.addTriplePattern(triple);
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (Node item : ss) {
            if (!item.isURI()) continue;
            exprs.add((Expr)new E_Equals((Expr)vs, (Expr)NodeValue.makeNode((Node)item)));
        }
        if (exprs.isEmpty()) {
            return null;
        }
        Expr or = ExprUtils.orifyBalanced(exprs);
        group.addElementFilter(new ElementFilter(or));
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        query.setConstructTemplate(new Template(bgp));
        query.setQueryPattern((Element)group);
        return query;
    }

    public static Query constructBySubject(Node s) {
        Triple triple = new Triple(s, (Node)p, (Node)o);
        BasicPattern basicPattern = new BasicPattern();
        basicPattern.add(triple);
        Template template = new Template(basicPattern);
        ElementGroup elementGroup = new ElementGroup();
        ElementPathBlock pathBlock = new ElementPathBlock();
        elementGroup.addElement((Element)pathBlock);
        pathBlock.addTriple(triple);
        Query query = new Query();
        query.setQueryConstructType();
        query.setConstructTemplate(template);
        query.setQueryPattern((Element)elementGroup);
        return query;
    }

    public static Query describe(Node node) {
        Query query = QueryFactory.create();
        query.setQueryDescribeType();
        query.getResultURIs().add(node);
        return query;
    }

    public static Query incoming(Node object) {
        return CannedQueryUtils.incoming("s", "p", object);
    }

    public static Query incoming(String varNameS, String varNameP, Node object) {
        Var s = Var.alloc((String)varNameS);
        Var p = Var.alloc((String)varNameP);
        return CannedQueryUtils.inOutTemplate((Node)s, (Node)p, object);
    }

    public static Query outgoing(Node subject) {
        return CannedQueryUtils.outgoing(subject, "p", "o");
    }

    public static Query outgoing(Node subject, String varNameP, String varNameO) {
        Var p = Var.alloc((String)varNameP);
        Var o = Var.alloc((String)varNameO);
        return CannedQueryUtils.inOutTemplate(subject, (Node)p, (Node)o);
    }

    public static Query inOutTemplate(Node s, Node p, Node o) {
        Query query = QueryFactory.create();
        query.setQueryConstructType();
        query.setDistinct(true);
        Triple triple = new Triple(s, p, o);
        ElementGroup group = new ElementGroup();
        group.addTriplePattern(triple);
        if (o.isVariable()) {
            group.addElementFilter(new ElementFilter((Expr)new E_IsURI((Expr)new ExprVar(o))));
            group.addElementFilter(new ElementFilter((Expr)new E_LogicalNot((Expr)new E_IsBlank((Expr)new ExprVar(o)))));
        }
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        query.setConstructTemplate(new Template(bgp));
        query.setQueryPattern((Element)group);
        return query;
    }
}

