/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.aksw.commons.collections.MultiMaps;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtils {
    private static Logger logger = LoggerFactory.getLogger(ModelUtils.class);

    public static Map<Resource, Set<Resource>> extractDirectSuperClassMap(Model model) {
        HashMap<Resource, Set<Resource>> result = new HashMap<Resource, Set<Resource>>();
        StmtIterator it = model.listStatements(null, RDFS.subClassOf, (RDFNode)null);
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            if (!(stmt.getObject() instanceof Resource)) continue;
            MultiMaps.put(result, (Object)stmt.getSubject(), (Object)((Resource)stmt.getObject()));
        }
        it.close();
        return result;
    }

    public static Model filterBySubject(Model model, Resource resource) {
        StmtIterator it = model.listStatements(resource, (Property)null, (RDFNode)null);
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes(model.getNsPrefixMap());
        while (it.hasNext()) {
            result.add((Statement)it.next());
        }
        return result;
    }

    public static Model combine(Collection<Model> models) {
        Model result = ModelFactory.createDefaultModel();
        for (Model model : models) {
            result.add(model);
        }
        return result;
    }

    public static Model read(InputStream in, String lang) throws IOException {
        return ModelUtils.read(ModelFactory.createDefaultModel(), in, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model read(File file) throws Exception {
        Set<String> langs = null;
        String fileName = file.getPath().toLowerCase();
        for (Map.Entry<String, String> entry : Constants.extensionToJenaFormat.entrySet()) {
            if (!fileName.endsWith(entry.getKey().toLowerCase())) continue;
            langs = Collections.singleton(entry.getValue());
            break;
        }
        if (langs == null) {
            langs = new HashSet<String>(Constants.extensionToJenaFormat.values());
        }
        String logMessage = "Parsing file '" + fileName + "' with languages " + langs + ": ";
        Model result = null;
        for (String lang : langs) {
            FileInputStream in = new FileInputStream(file);
            try {
                result = ModelUtils.read(in, lang);
                logMessage = logMessage + " Success (" + lang + ")";
                break;
            }
            catch (Exception e) {
                if (langs.size() != 1) continue;
                throw e;
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        if (result == null) {
            logMessage = logMessage + " Failed. ";
        }
        logger.debug(logMessage);
        if (result == null) {
            throw new IOException("Unsupported file format");
        }
        return result;
    }

    public static Model read(File file, String lang) throws IOException {
        return ModelUtils.read(new FileInputStream(file), lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model read(Model model, InputStream in, String lang) throws IOException {
        try {
            model.read(in, null, lang);
        }
        finally {
            in.close();
        }
        return model;
    }

    public static Model read(Model model, File file, String lang) throws IOException {
        return ModelUtils.read(model, new FileInputStream(file), lang);
    }

    public static Model write(Model model, File file) throws IOException {
        Map.Entry extToLang = StringUtils.getMatchBySuffix((String)file.getPath(), Constants.extensionToJenaFormat);
        String lang = extToLang == null ? null : (String)extToLang.getValue();
        return ModelUtils.write(model, file, lang);
    }

    public static Model write(Model model, File file, String lang) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        model.write((OutputStream)out, lang);
        out.close();
        return model;
    }

    public static String toString(Model model) {
        return ModelUtils.toString(model, "N3");
    }

    public static String toString(Model model, RDFWriter writer) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write(model, (OutputStream)baos, "");
        return baos.toString();
    }

    public static String toString(Model model, String format) {
        if (model == null) {
            return "null";
        }
        RDFWriter writer = model.getWriter(format);
        return ModelUtils.toString(model, writer);
    }

    public static String[] decompose(String uri, NavigableMap<String, String> prefixMap) {
        String prefix = "";
        String name = uri;
        Map.Entry candidate = StringUtils.longestPrefixLookup((String)uri, prefixMap);
        if (candidate != null && uri.startsWith((String)candidate.getKey())) {
            String candidateNs = (String)candidate.getKey();
            String candidatePrefix = (String)candidate.getValue();
            int splitIdx = candidateNs.length();
            prefix = candidatePrefix;
            name = uri.substring(splitIdx);
        }
        return new String[]{prefix, name};
    }

    public static String prettyUri(String uri, NavigableMap<String, String> prefixMap) {
        String[] tmp = ModelUtils.decompose(uri, prefixMap);
        String result = tmp[0].isEmpty() ? StringUtils.urlDecode((String)tmp[1]) : tmp[0] + ":" + StringUtils.urlDecode((String)tmp[1]);
        return result;
    }
}

