/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.Pair;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.FilterUtils;

public class DnfUtils {
    public static void main(String[] args) {
        String sA = "Select * { ?s ?p ?o . Filter(?o != <http://Person>). Optional { { ?x ?y ?z . Filter(?x != <http://x> && ?x = ?y) . } Union { ?x a ?y . Filter(?x = <http://x>) . } } . }";
        Query qA = QueryFactory.create((String)sA);
        Op opA = Algebra.compile((Query)qA);
        opA = Algebra.toQuadForm((Op)opA);
        System.out.println(opA);
        ExprList exprs = FilterUtils.collectExprs(opA, new ExprList());
        ExprList proc = DnfUtils.eval(exprs);
        System.out.println(proc);
        List<ExprList> clauses = DnfUtils.dnfToClauses((Iterable<Expr>)proc);
        System.out.println("Mentioned vars:" + proc.getVarsMentioned());
        System.out.println("Clauses: " + clauses);
    }

    public static Expr toExpr(List<List<Expr>> ors) {
        ArrayList<Expr> tmpOrs = new ArrayList<Expr>();
        for (List<Expr> ands : ors) {
            Expr and = ExprUtils.andifyBalanced(ands);
            tmpOrs.add(and);
        }
        if (ors.size() == 0) {
            return NodeValue.FALSE;
        }
        Expr result = ExprUtils.orifyBalanced(tmpOrs);
        return result;
    }

    public static void addConstantConstraint(Map<Var, NodeValue> map, Pair<Var, NodeValue> constraint) {
        if (constraint == null) {
            return;
        }
        DnfUtils.addConstantConstraint(map, (Var)constraint.getKey(), (NodeValue)constraint.getValue());
    }

    public static void addConstantConstraint(Map<Var, NodeValue> map, Var var, NodeValue nodeValue) {
        if (map.containsKey(var)) {
            NodeValue oldValue = map.get(var);
            if (oldValue != null && !oldValue.equals((Object)nodeValue)) {
                map.put(var, null);
            }
        } else {
            map.put(var, nodeValue);
        }
    }

    public static Map<Var, NodeValue> extractConstantConstraints(Set<Set<Expr>> dnf) {
        HashMap<Var, NodeValue> result = new HashMap<Var, NodeValue>();
        Iterator<Set<Expr>> clauseIt = dnf.iterator();
        if (!clauseIt.hasNext()) {
            return result;
        }
        Set<Expr> firstClause = clauseIt.next();
        for (Expr expr : firstClause) {
            Pair<Var, NodeValue> constraint = ExprUtils.extractConstantConstraint(expr);
            DnfUtils.addConstantConstraint(result, constraint);
        }
        HashSet<Object> seenVars = new HashSet<Object>();
        while (clauseIt.hasNext()) {
            if (result.isEmpty()) {
                return result;
            }
            Set<Expr> clause = clauseIt.next();
            for (Expr expr : clause) {
                Pair<Var, NodeValue> constraint = ExprUtils.extractConstantConstraint(expr);
                if (constraint == null || !result.containsKey(constraint.getKey())) continue;
                DnfUtils.addConstantConstraint(result, constraint);
                seenVars.add(constraint.getKey());
            }
            result.keySet().retainAll(seenVars);
            seenVars.clear();
        }
        return result;
    }

    public static Set<Set<Expr>> toSetDnf(Expr expr) {
        List<ExprList> clauses = DnfUtils.toClauses(expr);
        Set<Set<Expr>> dnf = FilterUtils.toSets(clauses);
        return dnf;
    }

    public static boolean isSatisfiable(Set<Set<Expr>> dnf) {
        for (Set<Expr> clause : dnf) {
            if (!ClauseUtils.isSatisfiable(clause)) continue;
            return true;
        }
        return false;
    }

    public static Expr dnfToExpr(Set<Set<Expr>> dnf, boolean skipUnsatisfiable) {
        HashSet<Expr> exprs = new HashSet<Expr>();
        for (Set<Expr> clause : dnf) {
            if (clause.size() > 1 && clause.contains(NodeValue.TRUE)) {
                clause.remove(NodeValue.TRUE);
            }
            if (skipUnsatisfiable && !ClauseUtils.isSatisfiable(clause)) continue;
            exprs.add(ExprUtils.andifyBalanced(clause));
        }
        Expr result = ExprUtils.orifyBalanced(exprs);
        return result != null ? result : NodeValue.FALSE;
    }

    public static Expr andifyLeftSided(ExprList exprs) {
        Expr result = null;
        for (Expr expr : exprs.getList()) {
            result = result == null ? expr : new E_LogicalAnd(result, expr);
        }
        return result;
    }

    public static List<ExprList> toClauses(Expr expr) {
        Expr evaluated = DnfUtils.eval(expr);
        return evaluated == null ? null : DnfUtils.dnfToClauses(Collections.singleton(evaluated));
    }

    public static List<ExprList> toClauses(ExprList exprs) {
        Expr evaluated = DnfUtils.eval(ExprUtils.andifyBalanced((Iterable<Expr>)exprs));
        return evaluated == null ? null : DnfUtils.dnfToClauses(Collections.singleton(evaluated));
    }

    public static List<ExprList> dnfToClauses(Iterable<Expr> exprs) {
        ArrayList<ExprList> result = new ArrayList<ExprList>();
        for (Expr expr : exprs) {
            DnfUtils.collectOr(expr, result);
        }
        return result;
    }

    public static void collectAnd(Expr expr, ExprList list) {
        if (expr instanceof E_LogicalAnd) {
            E_LogicalAnd e = (E_LogicalAnd)expr;
            DnfUtils.collectAnd(e.getArg1(), list);
            DnfUtils.collectAnd(e.getArg2(), list);
        } else {
            list.add(expr);
        }
    }

    public static void collectOr(Expr expr, List<ExprList> list) {
        if (expr instanceof E_LogicalOr) {
            E_LogicalOr e = (E_LogicalOr)expr;
            DnfUtils.collectOr(e.getArg1(), list);
            DnfUtils.collectOr(e.getArg2(), list);
        } else if (expr instanceof E_LogicalAnd) {
            ExprList ors = new ExprList();
            DnfUtils.collectAnd(expr, ors);
            list.add(ors);
        } else {
            list.add(new ExprList(expr));
        }
    }

    public static ExprList eval(ExprList exprs) {
        System.out.println("ExprList.size = " + exprs.size());
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            result.add(DnfUtils.eval(expr));
        }
        return result;
    }

    public static Expr eval(Expr expr) {
        if (expr instanceof ExprFunction) {
            return DnfUtils.handle((ExprFunction)expr);
        }
        return expr;
    }

    public static boolean containsDirectFuncChild(Expr expr, Class<?> clazz) {
        if (!(expr instanceof ExprFunction)) {
            return false;
        }
        ExprFunction func = (ExprFunction)expr;
        for (Expr arg : func.getArgs()) {
            if (arg == null || !clazz.isAssignableFrom(arg.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Expr handle(ExprFunction expr) {
        if (expr instanceof E_LogicalNot) {
            Expr tmp = ((E_LogicalNot)expr).getArg();
            if (!(tmp instanceof ExprFunction)) {
                return expr;
            }
            ExprFunction child = (ExprFunction)tmp;
            ExprFunction newExpr = expr;
            if (child instanceof E_LogicalAnd) {
                newExpr = new E_LogicalOr(DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(1))), DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(2))));
            } else if (child instanceof E_LogicalOr) {
                newExpr = new E_LogicalAnd(DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(1))), DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(2))));
            } else if (child instanceof E_LogicalNot) {
                newExpr = DnfUtils.eval(child.getArg(1));
            } else {
                return expr;
            }
            return DnfUtils.eval((Expr)newExpr);
        }
        if (expr instanceof E_LogicalOr) {
            return new E_LogicalOr(DnfUtils.eval(expr.getArg(1)), DnfUtils.eval(expr.getArg(2)));
        }
        if (expr instanceof E_LogicalAnd) {
            Expr aa = DnfUtils.eval(expr.getArg(1));
            Expr bb = DnfUtils.eval(expr.getArg(2));
            E_LogicalOr a = null;
            Expr b = null;
            if (aa instanceof E_LogicalOr) {
                a = (E_LogicalOr)aa;
                b = bb;
            } else if (bb instanceof E_LogicalOr) {
                a = (E_LogicalOr)bb;
                b = aa;
            }
            if (a == null) {
                return new E_LogicalAnd(aa, bb);
            }
            return new E_LogicalOr(DnfUtils.eval((Expr)new E_LogicalAnd(a.getArg(1), b)), DnfUtils.eval((Expr)new E_LogicalAnd(a.getArg(2), b)));
        }
        if (expr instanceof E_NotEquals) {
            return new E_LogicalNot(DnfUtils.eval((Expr)new E_Equals(expr.getArg(1), expr.getArg(2))));
        }
        return expr;
    }
}

