/*
 * Decompiled with CFR 0.152.
 */
package com.talis.rdfwriters.json;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONJenaWriter
implements RDFWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONJenaWriter.class);
    protected static final String propBase = "http://jena.hpl.hp.com/json/properties/";
    private String lineSeparator = JenaRuntime.getLineSeparator();
    private RDFErrorHandler errorHandler = null;
    private Map<String, Object> writerPropertyMap = null;
    private String baseURIref = null;
    private String baseURIrefHash = null;
    private Writer out = null;

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    public Object setProperty(String propName, Object propValue) {
        if (!(propValue instanceof String)) {
            LOG.warn("JSON.setProperty: Property for '" + propName + "' is not a string");
            propValue = propValue.toString();
        }
        propName = this.absolutePropName(propName);
        if (this.writerPropertyMap == null) {
            this.writerPropertyMap = new HashMap<String, Object>();
        }
        Object oldValue = this.writerPropertyMap.get(propName);
        this.writerPropertyMap.put(propName, propValue);
        return oldValue;
    }

    protected String absolutePropName(String propName) {
        if (propName.indexOf(58) == -1) {
            return propBase + propName;
        }
        return propName;
    }

    public void write(Model model, OutputStream output, String base) {
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            this.write(model, w, base);
            try {
                ((Writer)w).flush();
            }
            catch (IOException ioEx) {}
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Failed to create UTF-8 writer");
        }
    }

    public void write(Model baseModel, Writer _out, String base) {
        if (!(_out instanceof BufferedWriter)) {
            _out = new BufferedWriter(_out);
        }
        this.out = _out;
        if (base != null) {
            this.baseURIref = base;
            if (!base.endsWith("#") && !this.isOpaque(base)) {
                this.baseURIrefHash = this.baseURIref + "#";
            }
        }
        try {
            this.processModel(baseModel);
        }
        catch (IOException e) {
            LOG.error("IOError writing model.", (Throwable)e);
        }
    }

    private boolean isOpaque(String uri) {
        try {
            return new URI(uri).isOpaque();
        }
        catch (URISyntaxException ex) {
            return true;
        }
    }

    private void processModel(Model baseModel) throws IOException {
        this.writeLine("{");
        boolean first = true;
        ResIterator subjectIterator = baseModel.listSubjects();
        while (subjectIterator.hasNext()) {
            if (!first) {
                this.writeLine(",");
            }
            first = false;
            Resource subjectResource = subjectIterator.nextResource();
            this.processSubject(subjectResource);
        }
        this.writeLine("");
        this.writeLine("}");
    }

    private void processSubject(Resource subjectResource) throws IOException {
        this.write("  \"");
        if (subjectResource.isAnon()) {
            this.write("_:");
            this.write(this.escape(subjectResource.asNode().getBlankNodeId().getLabelString()));
        } else {
            this.write(this.escape(subjectResource.getURI()));
        }
        this.writeLine("\" : {");
        this.processProperties(subjectResource);
        this.write("  }");
    }

    private void processProperties(Resource subjectResource) throws IOException {
        HashSet<Property> propertiesToProcess = new HashSet<Property>();
        StmtIterator allPropertiesIterator = subjectResource.listProperties();
        while (allPropertiesIterator.hasNext()) {
            Statement statement = allPropertiesIterator.nextStatement();
            if (propertiesToProcess.contains(statement.getPredicate().getURI())) continue;
            propertiesToProcess.add(statement.getPredicate());
        }
        int processed = 0;
        for (Property property : propertiesToProcess) {
            this.write("    \"");
            this.write(this.escape(property.getURI()));
            this.write("\" : [ ");
            StmtIterator propertyIterator = subjectResource.listProperties(property);
            boolean moreThanOneValue = false;
            while (propertyIterator.hasNext()) {
                Statement propertyStatement = propertyIterator.nextStatement();
                boolean moreValues = propertyIterator.hasNext();
                if (moreValues) {
                    moreThanOneValue = true;
                }
                if (moreThanOneValue) {
                    this.writeLine("");
                    this.write("      ");
                }
                this.processProperty(propertyStatement);
                if (!moreValues) continue;
                this.write(",");
            }
            if (moreThanOneValue) {
                this.writeLine("");
                this.write("    ");
            } else {
                this.write(" ");
            }
            this.write("]");
            if (++processed < propertiesToProcess.size()) {
                this.write(",");
            }
            this.writeLine("");
        }
    }

    private void processProperty(Statement property) throws IOException {
        this.write("{ \"value\" : \"");
        if (property.getObject().isURIResource()) {
            Resource r = (Resource)property.getObject();
            this.write(this.escape(r.getURI()));
            this.write("\", \"type\" : \"uri\"");
        } else if (property.getObject().isLiteral()) {
            String dataTypeValue;
            Literal l = (Literal)property.getObject();
            this.write(this.escape(l.getLexicalForm()));
            this.write("\", \"type\" : \"literal\"");
            String languageValue = l.getLanguage();
            if (languageValue != null && !languageValue.trim().equals("")) {
                this.write(", \"lang\" : \"");
                this.write(languageValue);
                this.write("\"");
            }
            if ((dataTypeValue = l.getDatatypeURI()) != null && !dataTypeValue.trim().equals("")) {
                this.write(", \"datatype\" : \"");
                this.write(this.escape(dataTypeValue));
                this.write("\"");
            }
        } else if (property.getObject().isAnon()) {
            this.write("_:");
            this.write(this.escape(property.getObject().asNode().getBlankNodeId().getLabelString()));
            this.write("\", \"type\" : \"bnode\"");
        }
        this.write(" }");
    }

    protected String escape(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (c == '/') {
                builder.append("\\/");
                continue;
            }
            if (c == '\b') {
                builder.append("\\b");
                continue;
            }
            if (c == '\f') {
                builder.append("\\f");
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private void writeLine(String line) throws IOException {
        this.write(line);
        this.write(this.lineSeparator);
    }

    private void write(String line) throws IOException {
        this.out.write(line);
    }
}

