/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.util.NodeComparator;
import com.hp.hpl.jena.sparql.util.TripleComparator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aksw.jena_sparql_api.utils.TripleUtils;

public class QuadPatternUtils {
    public static String toNTripleString(QuadPattern quadPattern) throws Exception {
        List quads = quadPattern.getList();
        String result = "";
        for (Quad quad : quads) {
            Triple triple = quad.asTriple();
            String tmp = TripleUtils.toNTripleString(triple);
            if (!result.isEmpty()) {
                result = result + "\n";
            }
            result = result + tmp;
        }
        return result;
    }

    public static QuadPattern create(Iterable<Quad> quads) {
        QuadPattern result = new QuadPattern();
        for (Quad quad : quads) {
            result.add(quad);
        }
        return result;
    }

    public static QuadPattern toQuadPattern(BasicPattern basicPattern) {
        return QuadPatternUtils.toQuadPattern(Quad.defaultGraphNodeGenerated, basicPattern);
    }

    public static QuadPattern toQuadPattern(Node g, BasicPattern basicPattern) {
        QuadPattern result = new QuadPattern();
        for (Triple triple : basicPattern) {
            Quad quad = new Quad(g, triple);
            result.add(quad);
        }
        return result;
    }

    public static BasicPattern toBasicPattern(QuadPattern quadPattern) {
        BasicPattern result = new BasicPattern();
        for (Quad quad : quadPattern) {
            Triple triple = quad.asTriple();
            result.add(triple);
        }
        return result;
    }

    public static Map<Node, Set<Triple>> indexSorted(Iterable<Quad> quads) {
        TreeMap<Node, Set<Triple>> result = new TreeMap<Node, Set<Triple>>((Comparator<Node>)new NodeComparator());
        for (Quad q : quads) {
            TreeSet<Triple> triples = (TreeSet<Triple>)result.get(q.getGraph());
            if (triples == null) {
                triples = new TreeSet<Triple>((Comparator<Triple>)new TripleComparator());
                result.put(q.getGraph(), triples);
            }
            triples.add(q.asTriple());
        }
        return result;
    }

    public static Map<Node, Graph> indexAsGraphs(Iterable<Quad> quads) {
        HashMap<Node, Graph> result = new HashMap<Node, Graph>();
        for (Quad q : quads) {
            Graph graph = (Graph)result.get(q.getGraph());
            if (graph == null) {
                graph = GraphFactory.createDefaultGraph();
                result.put(q.getGraph(), graph);
            }
            graph.add(q.asTriple());
        }
        return result;
    }
}

