/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;

public class QuadUtils {
    public static final String ng = "g";
    public static final String ns = "s";
    public static final String np = "p";
    public static final String no = "o";
    public static final List<String> quadVarNames = Arrays.asList("g", "s", "p", "o");
    public static final Var vg = Var.alloc((String)"g");
    public static final Var vs = Var.alloc((String)"s");
    public static final Var vp = Var.alloc((String)"p");
    public static final Var vo = Var.alloc((String)"o");
    public static final List<Var> quadVars = Arrays.asList(vg, vs, vp, vo);

    public static Binding quadToBinding(Quad quad) {
        BindingHashMap result = new BindingHashMap();
        result.add(vg, quad.getGraph());
        result.add(vs, quad.getSubject());
        result.add(vp, quad.getPredicate());
        result.add(vo, quad.getObject());
        return result;
    }

    public static <K, V> Map<K, V> copySubstitute(Map<K, V> original, Map<K, K> map) {
        HashMap<Object, V> result = new HashMap<Object, V>();
        for (Map.Entry<K, V> entry : original.entrySet()) {
            result.put(MapUtils.getOrElse(map, entry.getKey(), entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Quad copySubstitute(Quad quad, Map<? extends Node, ? extends Node> map) {
        return new Quad((Node)MapUtils.getOrElse(map, (Object)quad.getGraph(), (Object)quad.getGraph()), (Node)MapUtils.getOrElse(map, (Object)quad.getSubject(), (Object)quad.getSubject()), (Node)MapUtils.getOrElse(map, (Object)quad.getPredicate(), (Object)quad.getPredicate()), (Node)MapUtils.getOrElse(map, (Object)quad.getObject(), (Object)quad.getObject()));
    }

    public static Quad create(Node[] nodes) {
        return new Quad(nodes[0], nodes[1], nodes[2], nodes[3]);
    }

    public static Node getNode(Quad quad, int index) {
        switch (index) {
            case 0: {
                return quad.getGraph();
            }
            case 1: {
                return quad.getSubject();
            }
            case 2: {
                return quad.getPredicate();
            }
            case 3: {
                return quad.getObject();
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index + " Size: " + 4);
    }

    public static Node substitute(Node node, Binding binding) {
        Node result = node;
        if (node.isVariable() && (result = binding.get((Var)node)) == null) {
            throw new RuntimeException("Variable " + node + "not bound");
        }
        return result;
    }

    public static Quad copySubstitute(Quad quad, Binding binding) {
        return new Quad(QuadUtils.substitute(quad.getGraph(), binding), QuadUtils.substitute(quad.getSubject(), binding), QuadUtils.substitute(quad.getPredicate(), binding), QuadUtils.substitute(quad.getObject(), binding));
    }

    public static QuadPattern copySubstitute(QuadPattern quadPattern, Map<? extends Node, ? extends Node> map) {
        QuadPattern result = new QuadPattern();
        for (Quad quad : quadPattern) {
            result.add(QuadUtils.copySubstitute(quad, map));
        }
        return result;
    }

    public static Quad listToQuad(List<Node> nodes) {
        return new Quad(nodes.get(0), nodes.get(1), nodes.get(2), nodes.get(3));
    }

    public static List<Node> quadToList(Quad quad) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(quad.getGraph());
        result.add(quad.getSubject());
        result.add(quad.getPredicate());
        result.add(quad.getObject());
        return result;
    }

    public static Set<Var> getVarsMentioned(QuadPattern quadPattern) {
        HashSet<Var> result = new HashSet<Var>();
        for (Quad quad : quadPattern) {
            result.addAll(QuadUtils.getVarsMentioned(quad));
        }
        return result;
    }

    public static Set<Var> getVarsMentioned(Quad quad) {
        return QuadUtils.getVarsMentioned(QuadUtils.quadToList(quad));
    }

    public static Set<Var> getVarsMentioned(Iterable<Node> nodes) {
        HashSet<Var> result = new HashSet<Var>();
        for (Node node : nodes) {
            if (!node.isVariable()) continue;
            result.add((Var)node);
        }
        return result;
    }

    public static Map<Node, Node> getVarMapping(Quad a, Quad b) {
        List<Node> nAs = QuadUtils.quadToList(a);
        List<Node> nBs = QuadUtils.quadToList(b);
        HashMap<Node, Node> result = new HashMap<Node, Node>();
        for (int i = 0; i < 4; ++i) {
            Node nA = nAs.get(i);
            Node nB = nBs.get(i);
            if (nA.isVariable()) {
                Map<Node, Node> newEntry = Collections.singletonMap(nA, nB);
                result.putAll(newEntry);
                continue;
            }
            if (nA.equals((Object)nB)) continue;
            return null;
        }
        return result;
    }
}

