/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriUtils {
    public static Multimap<String, String> parseQueryString(String queryString) {
        try {
            return UriUtils.parseQueryStringEx(queryString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Multimap<String, String> parseQueryStringEx(String queryString) throws UnsupportedEncodingException {
        ArrayListMultimap result = ArrayListMultimap.create();
        if (queryString == null) {
            return result;
        }
        for (String param : queryString.split("&")) {
            String[] pair = param.split("=");
            String key = URLDecoder.decode(pair[0], "UTF-8");
            String value = "";
            if (pair.length > 1) {
                value = URLDecoder.decode(pair[1], "UTF-8");
            }
            result.put((Object)new String(key), (Object)new String(value));
        }
        return result;
    }
}

