/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.utils.SparqlFormatterUtils;
import org.aksw.jena_sparql_api.utils.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessQuery {
    public static <T> StreamingOutput wrapWriter(final QueryExecution qe, final Writer<T> writer, final T obj) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                writer.write(output, obj);
                qe.close();
                output.flush();
            }
        };
    }

    public static StreamingOutput processQuery(String queryString, String format, QueryExecutionFactory qeFactory) throws Exception {
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL_11);
        StreamingOutput result = ProcessQuery.processQuery(query, format, qeFactory);
        return result;
    }

    public static StreamingOutput processQuery(Query query, String format, QueryExecutionFactory qeFactory) throws Exception {
        QueryExecution qe = qeFactory.createQueryExecution(query);
        StreamingOutput result = ProcessQuery.processQuery(query, format, qe);
        return result;
    }

    public static StreamingOutput processQuery(Query query, String format, QueryExecution qe) throws Exception {
        try {
            if (query.isAskType()) {
                Writer writer = SparqlFormatterUtils.getBooleanWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: Boolean -> " + format);
                }
                boolean value = qe.execAsk();
                return ProcessQuery.wrapWriter(qe, writer, value);
            }
            if (query.isConstructType()) {
                Writer writer = SparqlFormatterUtils.getTripleWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: Model -> " + format);
                }
                Iterator it = qe.execConstructTriples();
                return ProcessQuery.wrapWriter(qe, writer, it);
            }
            if (query.isSelectType()) {
                Writer writer = SparqlFormatterUtils.getResultSetWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: ResultSet -> " + format);
                }
                ResultSet resultSet = qe.execSelect();
                return ProcessQuery.wrapWriter(qe, writer, resultSet);
            }
            if (query.isDescribeType()) {
                Writer writer = SparqlFormatterUtils.getModelWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No formatter found: Model -> " + format);
                }
                Model model = ModelFactory.createDefaultModel();
                model.setNsPrefix("lgd-owl", "http://linkedgeodata.org/ontology/");
                model.setNsPrefix("lgd-node", "http://linkedgeodata.org/resource/node/");
                model.setNsPrefix("lgd-way", "http://linkedgeodata.org/resource/way/");
                qe.execDescribe(model);
                return ProcessQuery.wrapWriter(qe, writer, model);
            }
            throw new RuntimeException("Unknown query type");
        }
        catch (Exception e) {
            if (qe != null) {
                qe.close();
            }
            throw e;
        }
    }
}

