/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionAndType;
import org.aksw.jena_sparql_api.utils.SparqlFormatterUtils;
import org.aksw.jena_sparql_api.utils.Writer;

public class ProcessQuery {
    public static <T> StreamingOutput wrapWriter(final QueryExecution qe, final Writer<T> writer, final T obj) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                writer.write(output, obj);
                qe.close();
                output.flush();
            }
        };
    }

    public static StreamingOutput processQuery(QueryExecutionAndType queryAndType, String format) throws Exception {
        StreamingOutput result = ProcessQuery.processQuery(queryAndType.getQueryExecution(), queryAndType.getQueryType(), format);
        return result;
    }

    public static StreamingOutput processQuery(QueryExecution qe, int queryType, String format) throws Exception {
        try {
            if (queryType == 444) {
                Writer writer = SparqlFormatterUtils.getBooleanWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: Boolean -> " + format);
                }
                boolean value = qe.execAsk();
                return ProcessQuery.wrapWriter(qe, writer, value);
            }
            if (queryType == 222) {
                Writer writer = SparqlFormatterUtils.getTripleWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: Model -> " + format);
                }
                Iterator it = qe.execConstructTriples();
                return ProcessQuery.wrapWriter(qe, writer, it);
            }
            if (queryType == 111) {
                Writer writer = SparqlFormatterUtils.getResultSetWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: ResultSet -> " + format);
                }
                ResultSet resultSet = qe.execSelect();
                return ProcessQuery.wrapWriter(qe, writer, resultSet);
            }
            if (queryType == 333) {
                Writer writer = SparqlFormatterUtils.getModelWriter((String)format);
                if (writer == null) {
                    throw new RuntimeException("No formatter found: Model -> " + format);
                }
                Model model = ModelFactory.createDefaultModel();
                qe.execDescribe(model);
                return ProcessQuery.wrapWriter(qe, writer, model);
            }
            throw new RuntimeException("Unknown query type");
        }
        catch (Exception e) {
            if (qe != null) {
                qe.close();
            }
            throw e;
        }
    }
}

