/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.web;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionAndType;
import org.aksw.jena_sparql_api.web.ProcessQuery;
import org.aksw.jena_sparql_api.web.StreamingOutputString;

public abstract class SparqlEndpointBase {
    @Context
    private HttpServletRequest req;

    @Deprecated
    public QueryExecution createQueryExecution(Query query, @Context HttpServletRequest req) {
        QueryExecutionAndType tmp = this.createQueryExecution(query.toString());
        QueryExecution result = tmp.getQueryExecution();
        return result;
    }

    public QueryExecution createQueryExecution(Query query) {
        throw new RuntimeException("Not implemented");
    }

    public QueryExecutionAndType createQueryExecution(String queryString) {
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL_11);
        QueryExecution qe = this.createQueryExecution(query);
        QueryExecutionAndType result = new QueryExecutionAndType(qe, query.getQueryType());
        return result;
    }

    public Response processQuery(HttpServletRequest req, String queryString, String format) throws Exception {
        StreamingOutput so = this.processQueryToStreaming(queryString, format);
        Response response = Response.ok((Object)so).build();
        return response;
    }

    public StreamingOutput processQueryToStreaming(String queryString, String format) throws Exception {
        QueryExecutionAndType qeAndType = this.createQueryExecution(queryString);
        StreamingOutput result = ProcessQuery.processQuery(qeAndType, format);
        return result;
    }

    @GET
    @Produces(value={"application/xml"})
    public Response executeQueryXml(@Context HttpServletRequest req, @QueryParam(value="query") String queryString) throws Exception {
        if (queryString == null) {
            StreamingOutputString so = StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)so).build();
        }
        return this.processQuery(req, queryString, "Xml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response executeQueryXmlPost(@Context HttpServletRequest req, @FormParam(value="query") String queryString) throws Exception {
        if (queryString == null) {
            StreamingOutputString so = StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
            return Response.ok((Object)so).build();
        }
        return this.processQuery(req, queryString, "Xml");
    }

    @GET
    @Produces(value={"application/json", "application/sparql-results+json"})
    public Response executeQueryJson(@Context HttpServletRequest req, @QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "Json");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/sparql-results+json"})
    public Response executeQueryJsonPost(@Context HttpServletRequest req, @FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "Json");
    }

    @GET
    @Produces(value={"application/rdf+xml"})
    public Response executeQueryRdfXml(@Context HttpServletRequest req, @QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "RdfXml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/rdf+xml"})
    public Response executeQueryRdfXmlPost(@Context HttpServletRequest req, @FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "RdfXml");
    }

    @GET
    @Produces(value={"application/sparql-results+xml"})
    public Response executeQueryResultSetXml(@Context HttpServletRequest req, @QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "Xml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/sparql-results+xml"})
    public Response executeQueryResultSetXmlPost(@Context HttpServletRequest req, @FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "Xml");
    }

    @GET
    @Produces(value={"text/plain"})
    public Response executeQueryText(@Context HttpServletRequest req, @QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "Text");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response executeQueryTextPost(@Context HttpServletRequest req, @FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(req, queryString, "Text");
    }
}

