-- Empty - schema currently gets generated by hibernate

CREATE TABLE IF NOT EXISTS "query_cache"(
    "id" text PRIMARY KEY, -- ID is usually an MD5 hash of the query string
    "query_string" text, -- The query string is kept for reference
    "data" text, -- The result set
    "hit_count" int NOT NULL, -- Counter for how ofter the cache entry was hit
    "time_of_insertion" TIMESTAMP,
    "time_of_expiration" TIMESTAMP
);


CREATE INDEX "idx_query_cache_time_of_expiration" ON "query_cache"("time_of_expiration");
CREATE INDEX "idx_query_cache_hit_count" ON "query_cache"("hit_count");


