/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.geo;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import com.vividsolutions.jts.geom.Geometry;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.geo.GeoMapSupplierUtils;
import org.aksw.jena_sparql_api.geo.LinkGeomizer;
import org.aksw.jena_sparql_api.geo.LookupServiceUtilsGeo;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceCacheMem;
import org.aksw.jena_sparql_api.lookup.LookupServicePartition;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.utils.TripleUtils;

public class MainGeomizerTest {
    public static LookupService<Node, Geometry> createLookupService(QueryExecutionFactory sparqlService, MappedConcept mc) {
        LookupServicePartition result = LookupServiceUtilsGeo.createGeoLookupService(sparqlService, (MappedConcept<String>)mc);
        result = LookupServicePartition.create(result, (int)30, (int)5);
        result = LookupServiceCacheMem.create((LookupService)result);
        return result;
    }

    public static void main(String[] args) {
        Model model = FileManager.get().loadModel("/home/raven/Projects/Eclipse/24-7-platform/link-specifications/dbpedia-linkedgeodata-airport/positive.nt");
        Graph graph = model.getGraph();
        Set triples = graph.find(null, null, null).toSet();
        triples = TripleUtils.swap((Iterable)triples);
        QueryExecutionFactoryHttp sparqlServiceSource = new QueryExecutionFactoryHttp("http://dbpedia.org/sparql", "http://dbpedia.org");
        QueryExecutionFactoryHttp sparqlServiceTarget = new QueryExecutionFactoryHttp("http://linkedgeodata.org/sparql", "http://linkedgeodata.org");
        MappedConcept<Geometry> mcA = GeoMapSupplierUtils.mcWgsGeometry;
        MappedConcept<Geometry> mcB = GeoMapSupplierUtils.mcOgcGeometry;
        LookupService<Node, Geometry> lsA = MainGeomizerTest.createLookupService((QueryExecutionFactory)sparqlServiceSource, mcA);
        LookupService<Node, Geometry> lsB = MainGeomizerTest.createLookupService((QueryExecutionFactory)sparqlServiceTarget, mcB);
        Map<Triple, Geometry> map = LinkGeomizer.geomize(triples, lsA, lsB);
        Model result = ModelFactory.createDefaultModel();
        Set<Triple> ts = GeoMapSupplierUtils.geomizedToRdf(map);
        GraphUtil.add((Graph)result.getGraph(), ts.iterator());
        result.write((OutputStream)System.out, "N-TRIPLES");
    }
}

