/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.geo;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.RDF;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.mapper.AggTransform;
import org.aksw.jena_sparql_api.mapper.AggUtils;
import org.aksw.jena_sparql_api.mapper.FunctionNodeToString;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.utils.TripleUtils;

public class GeoMapSupplierUtils {
    public static final Var vs = Var.alloc((String)"s");
    public static final Var vw = Var.alloc((String)"w");
    public static final Var va = Var.alloc((String)"a");
    public static final Concept conceptWgsGeometry = GeoMapSupplierUtils.createConceptProperty(NodeFactory.createURI((String)"http://www.w3.org/2003/01/geo/wgs84_pos#geometry"));
    public static final Concept conceptOgcGeometry = GeoMapSupplierUtils.createConcept2(NodeFactory.createURI((String)"http://geovocab.org/geometry#geometry"), NodeFactory.createURI((String)"http://www.opengis.net/ont/geosparql#asWKT"));
    public static final MappedConcept mcWgsGeometry = new MappedConcept(conceptWgsGeometry, GeoMapSupplierUtils.createAggregatorWkt(vw));
    public static final MappedConcept mcOgcGeometry = new MappedConcept(conceptOgcGeometry, GeoMapSupplierUtils.createAggregatorWkt(vw));
    public static final String wktLiteralStr = "http://www.opengis.net/ont/geosparql#wktLiteral";
    public static final RDFDatatype geomType = TypeMapper.getInstance().getSafeTypeByName("http://www.opengis.net/ont/geosparql#wktLiteral");
    public static final String geomTypeVirtStr = "http://www.openlinksw.com/schemas/virtrdf#Geometry";
    public static final RDFDatatype geomTypeVirt = TypeMapper.getInstance().getSafeTypeByName("http://www.openlinksw.com/schemas/virtrdf#Geometry");
    public static Function<Triple, Triple> fnConvertOgcToVirt = new Function<Triple, Triple>(){

        public Triple apply(Triple t) {
            Triple result = GeoMapSupplierUtils.convertOgcToVirt(t);
            return result;
        }
    };

    public static Concept createConceptProperty(Node propertyNode) {
        BasicPattern pattern = new BasicPattern();
        pattern.add(new Triple((Node)vs, propertyNode, (Node)vw));
        ElementTriplesBlock element = new ElementTriplesBlock(pattern);
        Concept result = new Concept((Element)element, vs);
        return result;
    }

    public static Concept createConcept2(Node propertyNode1, Node propertyNode2) {
        BasicPattern pattern = new BasicPattern();
        pattern.add(new Triple((Node)vs, propertyNode1, (Node)va));
        pattern.add(new Triple((Node)va, propertyNode2, (Node)vw));
        ElementTriplesBlock element = new ElementTriplesBlock(pattern);
        Concept result = new Concept((Element)element, vs);
        return result;
    }

    public static final Agg<String> createAggregatorWkt(Var wktVar) {
        AggTransform result = AggTransform.create((Agg)AggUtils.literalNode((Expr)new ExprVar(wktVar)), (Function)FunctionNodeToString.fn);
        return result;
    }

    public static Set<Triple> geomizedToRdf(Map<Triple, Geometry> map) {
        HashSet<Triple> result = new HashSet<Triple>();
        Node Link = NodeFactory.createURI((String)"http://www.linklion.org/ontology#Link");
        Node ogcAsWkt = NodeFactory.createURI((String)"http://www.opengis.net/ont/geosparql#asWKT");
        for (Map.Entry<Triple, Geometry> entry : map.entrySet()) {
            Triple t = entry.getKey();
            String uri = "http://example.org/link-" + StringUtils.md5Hash((String)TripleUtils.toNTripleString((Triple)t));
            Node s = NodeFactory.createURI((String)uri);
            Node g = NodeFactory.createLiteral((String)entry.getValue().toText(), (RDFDatatype)geomType);
            result.add(new Triple(s, RDF.type.asNode(), Link));
            result.add(new Triple(s, RDF.subject.asNode(), t.getSubject()));
            result.add(new Triple(s, RDF.predicate.asNode(), t.getPredicate()));
            result.add(new Triple(s, RDF.object.asNode(), t.getObject()));
            result.add(new Triple(s, ogcAsWkt, g));
        }
        return result;
    }

    public static Triple convertOgcToVirt(Triple t) {
        String dt;
        Triple result = t;
        Node o = t.getObject();
        if (o.isLiteral() && (dt = o.getLiteralDatatypeURI()).equals(wktLiteralStr)) {
            Node newO = NodeFactory.createLiteral((String)o.getLiteralLexicalForm(), (RDFDatatype)geomTypeVirt);
            result = new Triple(t.getSubject(), t.getPredicate(), newO);
        }
        return result;
    }

    public static Set<Triple> convertOgcToVirt(Set<Triple> ts) {
        Collection tmp = Collections2.transform(ts, fnConvertOgcToVirt);
        HashSet<Triple> result = new HashSet<Triple>(tmp);
        return result;
    }
}

