/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.geo;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aksw.jena_sparql_api.lookup.LookupService;

public class LinkGeomizer {
    public static Map<Triple, Geometry> geomize(Iterable<Triple> triples, LookupService<Node, Geometry> lookupServiceSubjects, LookupService<Node, Geometry> lookupServiceObjects) {
        HashMap<Triple, Geometry> result = new HashMap<Triple, Geometry>();
        HashSet<Node> subjects = new HashSet<Node>();
        HashSet<Node> objects = new HashSet<Node>();
        for (Triple triple : triples) {
            subjects.add(triple.getSubject());
            objects.add(triple.getObject());
        }
        Map mapSubjects = lookupServiceSubjects.lookup(subjects);
        Map mapObjects = lookupServiceObjects.lookup(objects);
        System.out.println("mapSubjects: " + mapSubjects);
        System.out.println("mapObjects: " + mapObjects);
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
        for (Triple triple : triples) {
            Geometry gs = (Geometry)mapSubjects.get(triple.getSubject());
            Geometry go = (Geometry)mapObjects.get(triple.getObject());
            if (gs == null || go == null) continue;
            Coordinate[] coordinates = DistanceOp.nearestPoints((Geometry)gs, (Geometry)go);
            LineString lineString = gf.createLineString(coordinates);
            result.put(triple, (Geometry)lineString);
        }
        return result;
    }
}

