/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.example.proxy;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlEndpointProxyMain {
    private static final Logger logger = LoggerFactory.getLogger(SparqlEndpointProxyMain.class);
    private static final Options cliOptions = new Options();

    public static void printHelpAndExit(int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(SparqlEndpointProxyMain.class.getName(), cliOptions);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        logger.info("Launching server...");
        GnuParser cliParser = new GnuParser();
        cliOptions.addOption("P", "port", true, "Server port");
        cliOptions.addOption("s", "default service uri", true, "");
        cliOptions.addOption("o", "allow override of default service uri", true, "");
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        String portStr = commandLine.getOptionValue("P", "5522");
        int port = Integer.parseInt(portStr);
        String defaultServiceUri = commandLine.getOptionValue("s", "http://localhost/sparql");
        String allowOverrideServiceUriStr = commandLine.getOptionValue("o", "false");
        Boolean allowOverrideServiceUri = Boolean.parseBoolean(allowOverrideServiceUriStr);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", "org.aksw.jena_sparql_api.example.proxy");
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(sh, "/*");
        context.setAttribute("defaultServiceUri", (Object)defaultServiceUri);
        context.setAttribute("allowOverrideServiceUri", (Object)allowOverrideServiceUri);
        server.start();
    }
}

