/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.example.proxy;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.utils.UriUtils;
import org.aksw.jena_sparql_api.web.SparqlEndpointBase;

@Path(value="/sparql")
public class SparqlEndpointProxy
extends SparqlEndpointBase {
    private String defaultServiceUri;
    private boolean allowOverrideServiceUri = false;

    public SparqlEndpointProxy(@Context ServletContext context) {
        this.defaultServiceUri = (String)context.getAttribute("defaultServiceUri");
        Boolean tmp = (Boolean)context.getAttribute("allowOverrideServiceUri");
        boolean bl = this.allowOverrideServiceUri = tmp == null ? true : tmp;
        if (!this.allowOverrideServiceUri && (this.defaultServiceUri == null || this.defaultServiceUri.isEmpty())) {
            throw new RuntimeException("Overriding of service URI disabled, but no default URI set.");
        }
    }

    public QueryExecution createQueryExecution(Query query, @Context HttpServletRequest req) {
        String serviceUri;
        Multimap qs = UriUtils.parseQueryString((String)req.getQueryString());
        Collection serviceUris = qs.get((Object)"service-uri");
        if (serviceUris == null || serviceUris.isEmpty()) {
            serviceUri = this.defaultServiceUri;
        } else {
            serviceUri = (String)serviceUris.iterator().next();
            if (!this.allowOverrideServiceUri && !this.defaultServiceUri.equals(serviceUri)) {
                throw new RuntimeException("Access to any service other than " + this.defaultServiceUri + " is blocked.");
            }
        }
        if (serviceUri == null) {
            throw new RuntimeException("No SPARQL service URI sent with the request and no default one is configured");
        }
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(serviceUri);
        QueryExecution result = qef.createQueryExecution(query);
        return result;
    }
}

