/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.apache.commons.collections15.map.LRUMap;

public class LookupServiceCacheMem<K, V>
implements LookupService<K, V> {
    private Map<K, V> cache = new LRUMap();
    private LookupService<K, V> base;

    public LookupServiceCacheMem(LookupService<K, V> base) {
        this(base, 1000);
    }

    public LookupServiceCacheMem(LookupService<K, V> base, int maxCacheSize) {
        this(base, (Map<K, V>)new LRUMap(maxCacheSize));
    }

    public LookupServiceCacheMem(LookupService<K, V> base, Map<K, V> cache) {
        this.base = base;
        this.cache = cache;
    }

    public Map<K, V> apply(Iterable<K> keys) {
        HashMap<K, V> result = new HashMap<K, V>();
        HashSet<K> open = new HashSet<K>();
        for (K key : keys) {
            if (this.cache.containsKey(key)) {
                V v = this.cache.get(key);
                result.put(key, v);
                continue;
            }
            open.add(key);
        }
        Map remaining = (Map)this.base.apply(open);
        this.cache.putAll(remaining);
        result.putAll(remaining);
        return result;
    }

    public static <K, V> LookupServiceCacheMem<K, V> create(LookupService<K, V> base) {
        LookupServiceCacheMem<K, V> result = new LookupServiceCacheMem<K, V>(base);
        return result;
    }

    public static <K, V> LookupServiceCacheMem<K, V> create(LookupService<K, V> base, int maxCacheSize) {
        LookupServiceCacheMem<K, V> result = new LookupServiceCacheMem<K, V>(base, maxCacheSize);
        return result;
    }

    public static <K, V> LookupServiceCacheMem<K, V> create(LookupService<K, V> base, Map<K, V> cache) {
        LookupServiceCacheMem<K, V> result = new LookupServiceCacheMem<K, V>(base, cache);
        return result;
    }
}

