/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.aksw.jena_sparql_api.core.ResultSetClose;

public class ResultSetCloseable
extends ResultSetClose {
    private Closeable closeable;

    public ResultSetCloseable(ResultSet decoratee) {
        super(decoratee, true);
        this.closeable = null;
    }

    public ResultSetCloseable(ResultSet decoratee, Closeable closeable) {
        super(decoratee, true);
        if (closeable == null) {
            throw new NullPointerException();
        }
        this.closeable = closeable;
        super.checkClose();
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    public static ResultSetCloseable fromXml(InputStream xmlInputStream) {
        ResultSet rs = ResultSetFactory.fromXML((InputStream)xmlInputStream);
        ResultSetCloseable result = new ResultSetCloseable(rs, xmlInputStream);
        return result;
    }
}

