/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;

public class GraphQueryExecutionFactory
extends GraphBase {
    private QueryExecutionFactory qef;
    boolean delegateClose;

    public GraphQueryExecutionFactory(QueryExecutionFactory qef) {
        this(qef, true);
    }

    public GraphQueryExecutionFactory(QueryExecutionFactory qef, boolean delegateClose) {
        this.qef = qef;
        this.delegateClose = delegateClose;
    }

    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        Query query = new Query();
        query.setQueryConstructType();
        Node s = m.getMatchSubject();
        Node p = m.getMatchPredicate();
        Node o = m.getMatchObject();
        s = s == null ? Var.alloc((String)"s") : s;
        p = p == null ? Var.alloc((String)"p") : p;
        o = o == null ? Var.alloc((String)"o") : o;
        Triple triple = new Triple(s, p, o);
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        Template template = new Template(bgp);
        ElementTriplesBlock element = new ElementTriplesBlock(bgp);
        query.setConstructTemplate(template);
        query.setQueryPattern((Element)element);
        QueryExecution qe = this.qef.createQueryExecution(query);
        Iterator it = qe.execConstructTriples();
        WrappedIterator result = WrappedIterator.createNoRemove((Iterator)it);
        return result;
    }

    public void close() {
        if (this.delegateClose) {
            this.qef.close();
        }
    }
}

