/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.core;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import org.aksw.jena_sparql_api.cache.core.ModelProvider;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.core.QueryExecutionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCacheEx
extends QueryExecutionDecorator {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCacheEx.class);
    private CacheFrontend cache;
    private String service;
    private String queryString;
    private CacheResource currentResource = null;

    public QueryExecutionCacheEx(QueryExecution decoratee, String service, String queryString, CacheFrontend cache) {
        super(decoratee);
        this.service = service;
        this.queryString = queryString;
        this.cache = cache;
    }

    public static boolean needsCaching(CacheResource resource) {
        boolean result;
        if (resource == null) {
            result = true;
        } else if (resource.isOutdated()) {
            resource.close();
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public synchronized ResultSet doCacheResultSet() {
        CacheResource resource = this.cache.lookup(this.service, this.queryString);
        if (QueryExecutionCacheEx.needsCaching(resource)) {
            ResultSet rs;
            try {
                rs = this.getDecoratee().execSelect();
            }
            catch (Exception e) {
                try {
                    this.getDecoratee().abort();
                }
                catch (Exception x) {
                    logger.warn("Error", (Throwable)x);
                }
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cache.write(this.service, this.queryString, rs);
            resource = this.cache.lookup(this.service, this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        this.currentResource = resource;
        return resource.asResultSet();
    }

    public synchronized Model doCacheModel(Model result, ModelProvider modelProvider) {
        try {
            return this._doCacheModel(result, modelProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Model _doCacheModel(Model result, ModelProvider modelProvider) throws IOException {
        CacheResource resource = this.cache.lookup(this.service, this.queryString);
        if (QueryExecutionCacheEx.needsCaching(resource)) {
            Model model;
            try {
                model = modelProvider.getModel();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cache.write(this.service, this.queryString, model);
            resource = this.cache.lookup(this.service, this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return resource.asModel(result);
    }

    public synchronized boolean doCacheBoolean() {
        CacheResource resource = this.cache.lookup(this.service, this.queryString);
        if (QueryExecutionCacheEx.needsCaching(resource)) {
            boolean ret;
            try {
                ret = this.getDecoratee().execAsk();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cache.write(this.service, this.queryString, ret);
            resource = this.cache.lookup(this.service, this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return resource.asBoolean();
    }

    @Override
    public ResultSet execSelect() {
        return this.doCacheResultSet();
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheEx.this.getDecoratee().execConstruct();
            }
        });
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheEx.this.getDecoratee().execDescribe();
            }
        });
    }

    @Override
    public boolean execAsk() {
        return this.doCacheBoolean();
    }

    @Override
    public void close() {
        if (this.currentResource != null) {
            this.currentResource.close();
        }
    }
}

