/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.io.Closeable;
import java.io.IOException;
import org.aksw.jena_sparql_api.core.ResultSetDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetClose
extends ResultSetDecorator
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetClose.class);
    private boolean isClosed = false;
    private boolean closeOnException = true;

    public ResultSetClose(ResultSet decoratee, boolean skipCheckClose) {
        super(decoratee);
        if (!skipCheckClose) {
            this.checkClose();
        }
    }

    public ResultSetClose(ResultSet decoratee, boolean isClosed, boolean skipCheckClose) {
        super(decoratee);
        this.isClosed = isClosed;
        if (!skipCheckClose) {
            this.checkClose();
        }
    }

    public ResultSetClose(ResultSet decoratee, boolean isClosed, boolean closeOnException, boolean skipCheckClose) {
        super(decoratee);
        this.isClosed = isClosed;
        this.closeOnException = closeOnException;
        if (!skipCheckClose) {
            this.checkClose();
        }
    }

    protected boolean checkClose() {
        if (!this.isClosed) {
            boolean hasNext;
            try {
                hasNext = this.decoratee.hasNext();
            }
            catch (Exception e) {
                hasNext = false;
            }
            if (!hasNext) {
                try {
                    this.isClosed = true;
                    this.close();
                }
                catch (Exception e) {
                    logger.error("Error closing an object supposedly underlying a Jena ResultSet", (Throwable)e);
                }
            }
        }
        return this.isClosed;
    }

    @Override
    public boolean hasNext() {
        return !this.checkClose();
    }

    @Override
    public void remove() {
        this.decoratee.remove();
        this.checkClose();
    }

    @Override
    public QuerySolution nextSolution() {
        try {
            QuerySolution result = this.decoratee.nextSolution();
            this.checkClose();
            return result;
        }
        catch (Exception e) {
            if (this.closeOnException) {
                try {
                    this.close();
                }
                catch (Exception f) {
                    throw new RuntimeException(f);
                }
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Binding nextBinding() {
        try {
            Binding result = this.decoratee.nextBinding();
            this.checkClose();
            return result;
        }
        catch (Exception e) {
            if (this.closeOnException) {
                try {
                    this.close();
                }
                catch (Exception f) {
                    throw new RuntimeException(f);
                }
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed && this.decoratee instanceof Closeable) {
            Closeable closeable = (Closeable)this.decoratee;
            closeable.close();
            this.isClosed = true;
        }
    }
}

