/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL10;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.PatternVars;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.GeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.VarUtils;

public class Concept {
    private Element element;
    private Var var;

    public static Concept create(String elementStr, String varName) {
        ElementGroup group;
        List elements;
        Element element;
        boolean isEnclosed;
        Var var = Var.alloc((String)varName);
        String tmp = elementStr.trim();
        boolean bl = isEnclosed = tmp.startsWith("{") && tmp.endsWith("}");
        if (!isEnclosed) {
            tmp = "{" + tmp + "}";
        }
        if ((element = ParserSPARQL10.parseElement((String)tmp)) instanceof ElementGroup && (elements = (group = (ElementGroup)element).getElements()).size() == 1) {
            element = (Element)elements.get(0);
        }
        Concept result = new Concept(element, var);
        return result;
    }

    public boolean isSubjectConcept() {
        List triples;
        if (this.element instanceof ElementTriplesBlock && (triples = ((ElementTriplesBlock)this.element).getPattern().getList()).size() == 1) {
            boolean condition;
            Triple triple = (Triple)triples.get(0);
            boolean bl = condition = triple.getSubject().isVariable() && triple.getSubject().equals((Object)this.var) && triple.getPredicate().isVariable() && triple.getObject().isVariable();
            if (condition) {
                return true;
            }
        }
        return false;
    }

    public Concept(Element element, Var var) {
        this.element = element;
        this.var = var;
    }

    public Concept(List<Element> elements, Var var) {
        ElementGroup group = new ElementGroup();
        for (Element item : elements) {
            if (item instanceof ElementTriplesBlock) {
                ElementTriplesBlock tmp = (ElementTriplesBlock)item;
                for (Triple t : tmp.getPattern()) {
                    group.addTriplePattern(t);
                }
                continue;
            }
            group.addElement(item);
        }
        this.element = group;
        this.var = var;
    }

    public Element getElement() {
        return this.element;
    }

    public List<Element> getElements() {
        return ElementUtils.toElementList((Element)this.element);
    }

    public Var getVar() {
        return this.var;
    }

    public Concept makeDistinctFrom(Concept that) {
        HashSet thisVarNames = new HashSet(VarUtils.getVarNames((Iterable)PatternVars.vars((Element)this.getElement())));
        HashSet thatVarNames = new HashSet(VarUtils.getVarNames((Iterable)PatternVars.vars((Element)that.getElement())));
        Sets.SetView commonVarNames = Sets.intersection(thisVarNames, thatVarNames);
        Sets.SetView combinedVarNames = Sets.union(thisVarNames, thatVarNames);
        GeneratorBlacklist generator = new GeneratorBlacklist((Generator)Gensym.create((String)"v"), (Collection)combinedVarNames);
        BindingHashMap binding = new BindingHashMap();
        for (String varName : commonVarNames) {
            Var oldVar = Var.alloc((String)varName);
            Var newVar = Var.alloc((String)generator.next());
            binding.add(oldVar, (Node)newVar);
        }
        Op op = Algebra.compile((Element)this.element);
        Op substOp = Substitute.substitute((Op)op, (Binding)binding);
        Query tmp = OpAsQuery.asQuery((Op)substOp);
        ElementGroup newElement = new ElementGroup();
        newElement.addElement(tmp.getQueryPattern());
        Var tmpVar = (Var)binding.get(this.var);
        Var newVar = tmpVar != null ? tmpVar : this.var;
        Concept result = new Concept((Element)newElement, newVar);
        return result;
    }

    public Query asQuery() {
        Query result = new Query();
        result.setQuerySelectType();
        result.setQueryPattern(this.element);
        result.setDistinct(true);
        result.getProjectVars().add(this.var);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.var == null ? 0 : this.var.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Concept other = (Concept)obj;
        if (this.element == null ? other.element != null : !this.element.equals((Object)other.element)) {
            return false;
        }
        return !(this.var == null ? other.var != null : !this.var.equals((Object)other.var));
    }

    public String toString() {
        return "Concept [element=" + this.element + ", var=" + this.var + "]";
    }
}

