/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.file;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.ResultSetCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFile {
    private static final Logger logger = LoggerFactory.getLogger(CacheFile.class);
    private String basePath;
    private QueryExecutionFactory decoratee;

    public ResultSet executeSelectXml(String queryString) throws IOException {
        logger.trace("Query is: " + queryString);
        File file = this.getCacheFile(this.decoratee.getId(), this.decoratee.getState(), queryString);
        logger.trace("Cache file: " + file.getAbsolutePath());
        if (file == null) {
            // empty if block
        }
        FileInputStream in = new FileInputStream(file);
        ResultSetCloseable result = ResultSetCloseable.fromXml(in);
        return result;
    }

    private File getCacheFile(String id, String state, String queryString) {
        String dirPart = this.basePath + "/" + StringUtils.urlEncode((String)id) + "/";
        String dir = dirPart + state + "/";
        File result = new File("" + dir + StringUtils.md5Hash((String)queryString));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheResultSetXml(ResultSet rs, File file) throws IOException {
        File directory = file.getParentFile();
        directory.mkdirs();
        File tmpFile = File.createTempFile("sparqlResultSet_", ".tmp", directory);
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            ResultSetFormatter.outputAsXML((OutputStream)out, (ResultSet)rs);
        }
        finally {
            out.flush();
            ((OutputStream)out).close();
        }
        tmpFile.renameTo(file);
    }
}

