/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.fallback;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.aksw.jena_sparql_api.core.QueryExecutionDecorator;
import org.aksw.jena_sparql_api.fallback.QueryExecutionFallbackFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionFallback
extends QueryExecutionDecorator {
    private final Logger logger = LoggerFactory.getLogger(QueryExecutionFallback.class);
    private List<QueryExecution> decoratees;
    private ReturnPreference returnPreference = ReturnPreference.BEST_SUCCESSFUL;

    public QueryExecutionFallback(List<QueryExecution> decoratees) {
        super(null);
        this.decoratees = decoratees;
    }

    @Override
    public boolean execAsk() {
        for (QueryExecution qe : this.decoratees) {
            try {
                return qe.execAsk();
            }
            catch (Exception e) {
                this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
            }
        }
        throw new QueryExecutionFallbackFailedException();
    }

    @Override
    public ResultSet execSelect() {
        ExecutorService threadPool = Executors.newFixedThreadPool(this.decoratees.size());
        ExecutorCompletionService<ResultSet> completionService = new ExecutorCompletionService<ResultSet>(threadPool);
        ArrayList<Future<ResultSet>> futures = new ArrayList<Future<ResultSet>>(this.decoratees.size());
        for (final QueryExecution qe : this.decoratees) {
            futures.add(completionService.submit(new Callable<ResultSet>(){

                @Override
                public ResultSet call() throws Exception {
                    try {
                        return qe.execSelect();
                    }
                    catch (Exception e) {
                        QueryExecutionFallback.this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
                        return null;
                    }
                }
            }));
        }
        ArrayList<ResultSet> results = new ArrayList<ResultSet>(Collections.nCopies(this.decoratees.size(), null));
        boolean firstSuccessful = true;
        int bestSuccessfulIndex = -1;
        int bestFailedIndex = this.decoratees.size();
        int bestIndex = 0;
        for (int i = 0; i < this.decoratees.size(); ++i) {
            try {
                Future future = completionService.take();
                ResultSet result = (ResultSet)future.get();
                int currentIndex = futures.indexOf(future);
                System.out.println("Finished " + (currentIndex + 1) + ". query execution. Status: " + (result == null ? "failed" : "successful"));
                if (result != null) {
                    if (this.returnPreference == ReturnPreference.FIRST_SUCCESSFUL && firstSuccessful) {
                        System.out.println("Returning first successful solution returned by " + (currentIndex + 1) + ". query execution.");
                        this.shutdownAll(threadPool, currentIndex);
                        return result;
                    }
                    if (currentIndex == bestIndex) {
                        System.out.println("Returning best successful solution.");
                        this.shutdownAll(threadPool, currentIndex);
                        return result;
                    }
                    firstSuccessful = false;
                    bestSuccessfulIndex = Math.min(currentIndex, bestSuccessfulIndex);
                } else {
                    bestFailedIndex = Math.min(currentIndex, bestFailedIndex);
                    if (currentIndex == bestIndex) {
                        ++bestIndex;
                    }
                }
                if (bestSuccessfulIndex - bestFailedIndex == 1) {
                    System.out.println("Returning best successful solution.");
                    this.shutdownAll(threadPool, currentIndex);
                    return (ResultSet)results.get(bestSuccessfulIndex);
                }
                results.add(currentIndex, result);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        threadPool.shutdown();
        for (ResultSet result : results) {
            if (result == null) continue;
            return result;
        }
        throw new QueryExecutionFallbackFailedException();
    }

    private void shutdownAll(ExecutorService threadPool, int position) {
        for (int j = 0; j < this.decoratees.size(); ++j) {
            if (j == position) continue;
            System.out.println("Cancelling " + (j + 1) + ". query execution.");
            this.decoratees.get(j).abort();
        }
        threadPool.shutdownNow();
    }

    public ResultSet execSelectMultihreaded() {
        ExecutorService threadPool = Executors.newFixedThreadPool(this.decoratees.size());
        ExecutorCompletionService completionService = new ExecutorCompletionService(threadPool);
        ArrayList futures = new ArrayList(this.decoratees.size());
        for (final QueryExecution qe : this.decoratees) {
            QueryExecutionTask<ResultSet> task = new QueryExecutionTask<ResultSet>(new Callable<ResultSet>(){

                @Override
                public ResultSet call() throws Exception {
                    try {
                        return qe.execSelect();
                    }
                    catch (Exception e) {
                        QueryExecutionFallback.this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
                        return null;
                    }
                }
            });
            threadPool.submit(task);
        }
        threadPool.shutdown();
        throw new QueryExecutionFallbackFailedException();
    }

    @Override
    public Model execConstruct() {
        for (QueryExecution qe : this.decoratees) {
            try {
                return qe.execConstruct();
            }
            catch (Exception e) {
                this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
            }
        }
        throw new QueryExecutionFallbackFailedException();
    }

    @Override
    public Model execConstruct(Model model) {
        for (QueryExecution qe : this.decoratees) {
            try {
                return qe.execConstruct(model);
            }
            catch (Exception e) {
                this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
            }
        }
        throw new QueryExecutionFallbackFailedException();
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        for (QueryExecution qe : this.decoratees) {
            try {
                return qe.execConstructTriples();
            }
            catch (Exception e) {
                this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
            }
        }
        throw new QueryExecutionFallbackFailedException();
    }

    @Override
    public Model execDescribe() {
        for (QueryExecution qe : this.decoratees) {
            try {
                return qe.execDescribe();
            }
            catch (Exception e) {
                this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
            }
        }
        throw new QueryExecutionFallbackFailedException();
    }

    @Override
    public Model execDescribe(Model model) {
        for (QueryExecution qe : this.decoratees) {
            try {
                return qe.execDescribe(model);
            }
            catch (Exception e) {
                this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
            }
        }
        throw new QueryExecutionFallbackFailedException();
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        for (QueryExecution qe : this.decoratees) {
            try {
                return qe.execDescribeTriples();
            }
            catch (Exception e) {
                this.logger.warn(String.format("Query execution failed. Tried %s", qe), (Throwable)e);
            }
        }
        throw new QueryExecutionFallbackFailedException();
    }

    class QueryExecutionTask<T>
    extends FutureTask<T> {
        private QueryExecution qe;

        public QueryExecutionTask(Callable<T> callable) {
            super(callable);
        }

        public QueryExecutionTask(QueryExecution qe, Callable<T> callable) {
            super(callable);
            this.qe = qe;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.qe.abort();
            System.out.println("Aborting...");
            return super.cancel(mayInterruptIfRunning);
        }
    }

    static enum ReturnPreference {
        FIRST_SUCCESSFUL,
        BEST_SUCCESSFUL;

    }
}

