/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.mapper.Acc;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.mapper.BindingMapper;

public class AccMap<K, V>
implements Acc<Map<K, V>> {
    private BindingMapper<K> mapper;
    private Agg<V> subAgg;
    private Map<K, Acc<V>> state;

    public AccMap(BindingMapper<K> mapper, Agg<V> subAgg) {
        this.mapper = mapper;
        this.subAgg = subAgg;
    }

    @Override
    public void accumulate(Binding binding) {
        K k = this.mapper.map(binding, -1L);
        Acc<V> subAcc = this.state.get(k);
        if (subAcc == null) {
            subAcc = this.subAgg.createAccumulator();
            this.state.put(k, subAcc);
        }
        subAcc.accumulate(binding);
    }

    @Override
    public Map<K, V> getValue() {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, Acc<V>> entry : this.state.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue().getValue();
            result.put(k, v);
        }
        return result;
    }
}

