/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.fallback;

import com.google.common.collect.Lists;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackQuery;
import org.aksw.jena_sparql_api.fallback.QueryExecutionFallback;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;

public class QueryExecutionFactoryFallback
extends QueryExecutionFactoryBackQuery {
    private List<QueryExecutionFactory> decoratees;

    public QueryExecutionFactoryFallback(PriorityQueue<QueryExecutionFactory> decoratees) {
        this.decoratees = Lists.newArrayList(decoratees);
    }

    public QueryExecutionFactoryFallback(List<QueryExecutionFactory> decoratees) {
        this.decoratees = decoratees;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        ArrayList<QueryExecution> queryExecutions = new ArrayList<QueryExecution>(this.decoratees.size());
        for (QueryExecutionFactory decoratee : this.decoratees) {
            QueryExecution qe = decoratee.createQueryExecution(query);
            queryExecutions.add(qe);
        }
        return new QueryExecutionFallback((List<QueryExecution>)queryExecutions);
    }

    @Override
    public QueryExecution createQueryExecution(String queryString) {
        ArrayList<QueryExecution> queryExecutions = new ArrayList<QueryExecution>(this.decoratees.size());
        for (QueryExecutionFactory decoratee : this.decoratees) {
            QueryExecution qe = decoratee.createQueryExecution(queryString);
            queryExecutions.add(qe);
        }
        return new QueryExecutionFallback((List<QueryExecution>)queryExecutions);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public String getState() {
        return null;
    }

    public static void main(String[] args) throws Exception {
        QueryExecutionFactoryHttp qef1 = new QueryExecutionFactoryHttp("http://dbpedia.org/sparql", "http://dbpedia.org");
        QueryExecutionFactoryHttp qef2 = new QueryExecutionFactoryHttp("http://live.dbpedia.org/sparql", "http://dbpedia.org");
        QueryExecutionFactoryHttp qef3 = new QueryExecutionFactoryHttp("http://lod.openlinksw.org/sparql", "http://dbpedia.org");
        ArrayList<QueryExecutionFactory> qefs = new ArrayList<QueryExecutionFactory>();
        qefs.add(qef1);
        qefs.add(qef2);
        qefs.add(qef3);
        QueryExecutionFactoryFallback qef = new QueryExecutionFactoryFallback(qefs);
        String query = "SELECT * WHERE {?s a <http://dbpedia.org/ontology/Book>.} LIMIT 10";
        QueryExecution qe = qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        System.out.println(ResultSetFormatter.asText((ResultSet)rs));
    }
}

