/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.retry.core;

import com.blogspot.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.blogspot.nurkiewicz.asyncretry.backoff.Backoff;
import com.blogspot.nurkiewicz.asyncretry.policy.RetryPolicy;
import com.google.common.util.concurrent.ListenableFuture;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.aksw.jena_sparql_api.core.QueryExecutionDecorator;

public class QueryExecutionRetry
extends QueryExecutionDecorator {
    private int retryCount;
    private long retryDelayInMs;
    private RetryPolicy retryPolicy;
    private Backoff backoff;
    private boolean fixedDelay;

    public QueryExecutionRetry(QueryExecution decoratee, int retryCount, long retryDelayInMs) {
        super(decoratee);
        this.retryCount = retryCount;
        this.retryDelayInMs = retryDelayInMs;
    }

    public QueryExecutionRetry(QueryExecution decoratee, RetryPolicy retryPolicy, Backoff backoff, boolean fixedDelay) {
        super(decoratee);
        this.retryPolicy = retryPolicy;
        this.backoff = backoff;
        this.fixedDelay = fixedDelay;
    }

    public <T> T doTry(Callable<T> callable) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        AsyncRetryExecutor executor = new AsyncRetryExecutor(scheduler, this.retryPolicy, this.backoff, this.fixedDelay);
        ListenableFuture future = executor.getWithRetry(callable);
        try {
            Object result;
            Object object = result = future.get();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Query Execution failed, even with retries.", e);
        }
        finally {
            scheduler.shutdown();
        }
    }

    @Override
    public boolean execAsk() {
        return this.doTry(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return QueryExecutionRetry.super.execAsk();
            }
        });
    }

    @Override
    public ResultSet execSelect() {
        return this.doTry(new Callable<ResultSet>(){

            @Override
            public ResultSet call() throws Exception {
                return QueryExecutionRetry.super.execSelect();
            }
        });
    }

    @Override
    public Model execConstruct() {
        return this.doTry(new Callable<Model>(){

            @Override
            public Model call() throws Exception {
                return QueryExecutionRetry.super.execConstruct();
            }
        });
    }

    @Override
    public Model execConstruct(final Model model) {
        return this.doTry(new Callable<Model>(){

            @Override
            public Model call() throws Exception {
                return QueryExecutionRetry.super.execConstruct(model);
            }
        });
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        return this.doTry(new Callable<Iterator<Triple>>(){

            @Override
            public Iterator<Triple> call() throws Exception {
                return QueryExecutionRetry.super.execConstructTriples();
            }
        });
    }

    @Override
    public Model execDescribe() {
        return this.doTry(new Callable<Model>(){

            @Override
            public Model call() throws Exception {
                return QueryExecutionRetry.super.execDescribe();
            }
        });
    }

    @Override
    public Model execDescribe(final Model model) {
        return this.doTry(new Callable<Model>(){

            @Override
            public Model call() throws Exception {
                return QueryExecutionRetry.super.execDescribe(model);
            }
        });
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        return this.doTry(new Callable<Iterator<Triple>>(){

            @Override
            public Iterator<Triple> call() throws Exception {
                return QueryExecutionRetry.super.execDescribeTriples();
            }
        });
    }
}

