/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.retry.core;

import com.blogspot.nurkiewicz.asyncretry.backoff.Backoff;
import com.blogspot.nurkiewicz.asyncretry.backoff.BoundedMaxBackoff;
import com.blogspot.nurkiewicz.asyncretry.backoff.BoundedMinBackoff;
import com.blogspot.nurkiewicz.asyncretry.backoff.ExponentialDelayBackoff;
import com.blogspot.nurkiewicz.asyncretry.backoff.FixedIntervalBackoff;
import com.blogspot.nurkiewicz.asyncretry.backoff.ProportionalRandomBackoff;
import com.blogspot.nurkiewicz.asyncretry.backoff.UniformRandomBackoff;
import com.blogspot.nurkiewicz.asyncretry.policy.MaxRetriesPolicy;
import com.blogspot.nurkiewicz.asyncretry.policy.RetryPolicy;
import com.blogspot.nurkiewicz.asyncretry.policy.exception.AbortPredicateRetryPolicy;
import com.blogspot.nurkiewicz.asyncretry.policy.exception.ExceptionClassRetryPolicy;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.util.concurrent.TimeUnit;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDecorator;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.retry.core.QueryExecutionRetry;

public class QueryExecutionFactoryRetry
extends QueryExecutionFactoryDecorator {
    private int retryCount;
    private long retryDelayInMs;
    private final boolean fixedDelay;
    private final RetryPolicy retryPolicy;
    private final Backoff backoff;

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee, int retryCount, long retryDelayInMs) {
        this(decoratee, (RetryPolicy)new MaxRetriesPolicy(RetryPolicy.DEFAULT, retryCount), (Backoff)new FixedIntervalBackoff(retryDelayInMs), true);
        this.retryCount = retryCount;
        this.retryDelayInMs = retryDelayInMs;
    }

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee, int retryCount, long retryDelayDuration, TimeUnit retryDelayTimeUnit) {
        this(decoratee, (RetryPolicy)new MaxRetriesPolicy(RetryPolicy.DEFAULT, retryCount), (Backoff)new FixedIntervalBackoff(retryDelayTimeUnit.toMillis(retryDelayDuration)), true);
        this.retryCount = retryCount;
        this.retryDelayInMs = retryDelayTimeUnit.toMillis(retryDelayDuration);
    }

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee) {
        this(decoratee, RetryPolicy.DEFAULT, Backoff.DEFAULT);
    }

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee, Backoff backoff) {
        this(decoratee, RetryPolicy.DEFAULT, backoff);
    }

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee, RetryPolicy retryPolicy) {
        this(decoratee, retryPolicy, Backoff.DEFAULT);
    }

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee, RetryPolicy retryPolicy, Backoff backoff) {
        this(decoratee, retryPolicy, backoff, false);
    }

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee, RetryPolicy retryPolicy, Backoff backoff, boolean fixedDelay) {
        super(decoratee);
        this.retryPolicy = (RetryPolicy)Preconditions.checkNotNull((Object)retryPolicy);
        this.backoff = (Backoff)Preconditions.checkNotNull((Object)backoff);
        this.fixedDelay = fixedDelay;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        QueryExecution qe = super.createQueryExecution(query);
        QueryExecutionRetry result = new QueryExecutionRetry(qe, this.retryPolicy, this.backoff, this.fixedDelay);
        return result;
    }

    @Override
    public QueryExecution createQueryExecution(String queryString) {
        QueryExecution qe = super.createQueryExecution(queryString);
        QueryExecutionRetry result = new QueryExecutionRetry(qe, this.retryPolicy, this.backoff, this.fixedDelay);
        return result;
    }

    public QueryExecutionFactoryRetry withRetryPolicy(RetryPolicy retryPolicy) {
        return new QueryExecutionFactoryRetry(this.decoratee, retryPolicy, this.backoff, this.fixedDelay);
    }

    public QueryExecutionFactoryRetry withBackoff(Backoff backoff) {
        return new QueryExecutionFactoryRetry(this.decoratee, this.retryPolicy, backoff, this.fixedDelay);
    }

    public QueryExecutionFactoryRetry withExponentialBackoff(long initialDelayMillis, double multiplier) {
        ExponentialDelayBackoff backoff = new ExponentialDelayBackoff(initialDelayMillis, multiplier);
        return new QueryExecutionFactoryRetry(this.decoratee, this.retryPolicy, (Backoff)backoff, this.fixedDelay);
    }

    public QueryExecutionFactoryRetry withFixedBackoff(long delayMillis) {
        FixedIntervalBackoff backoff = new FixedIntervalBackoff(delayMillis);
        return new QueryExecutionFactoryRetry(this.decoratee, this.retryPolicy, (Backoff)backoff, this.fixedDelay);
    }

    public QueryExecutionFactoryRetry withFixedRate() {
        return new QueryExecutionFactoryRetry(this.decoratee, this.retryPolicy, this.backoff, true);
    }

    public QueryExecutionFactoryRetry withFixedRate(boolean fixedDelay) {
        return new QueryExecutionFactoryRetry(this.decoratee, this.retryPolicy, this.backoff, fixedDelay);
    }

    @SafeVarargs
    public QueryExecutionFactoryRetry retryOn(Class<? extends Throwable> ... retryOnThrowable) {
        return this.withRetryPolicy((RetryPolicy)ExceptionClassRetryPolicy.retryOn((RetryPolicy)this.retryPolicy, (Class[])retryOnThrowable));
    }

    @SafeVarargs
    public QueryExecutionFactoryRetry abortOn(Class<? extends Throwable> ... abortOnThrowable) {
        return this.withRetryPolicy((RetryPolicy)ExceptionClassRetryPolicy.abortOn((RetryPolicy)this.retryPolicy, (Class[])abortOnThrowable));
    }

    public QueryExecutionFactoryRetry abortIf(Predicate<Throwable> abortPredicate) {
        return this.withRetryPolicy((RetryPolicy)new AbortPredicateRetryPolicy(this.retryPolicy, abortPredicate));
    }

    public QueryExecutionFactoryRetry withUniformJitter() {
        return this.withBackoff((Backoff)new UniformRandomBackoff(this.backoff));
    }

    public QueryExecutionFactoryRetry withUniformJitter(long range) {
        return this.withBackoff((Backoff)new UniformRandomBackoff(this.backoff, range));
    }

    public QueryExecutionFactoryRetry withProportionalJitter() {
        return this.withBackoff((Backoff)new ProportionalRandomBackoff(this.backoff));
    }

    public QueryExecutionFactoryRetry withProportionalJitter(double multiplier) {
        return this.withBackoff((Backoff)new ProportionalRandomBackoff(this.backoff, multiplier));
    }

    public QueryExecutionFactoryRetry withMinDelay(long minDelayMillis) {
        return this.withBackoff((Backoff)new BoundedMinBackoff(this.backoff, minDelayMillis));
    }

    public QueryExecutionFactoryRetry withMaxDelay(long maxDelayMillis) {
        return this.withBackoff((Backoff)new BoundedMaxBackoff(this.backoff, maxDelayMillis));
    }

    public QueryExecutionFactoryRetry withMaxRetries(int times) {
        return this.withRetryPolicy((RetryPolicy)new MaxRetriesPolicy(this.retryPolicy, times));
    }

    public QueryExecutionFactoryRetry dontRetry() {
        return this.withRetryPolicy((RetryPolicy)new MaxRetriesPolicy(this.retryPolicy, 0));
    }

    public QueryExecutionFactoryRetry withNoDelay() {
        return this.withBackoff((Backoff)new FixedIntervalBackoff(0L));
    }

    public static void main(String[] args) throws Exception {
        QueryExecutionFactory qef = new QueryExecutionFactoryHttp("http://live.dbpedia.org/sparql", "http://dbpedia.org");
        qef = new QueryExecutionFactoryRetry(qef).retryOn(Exception.class).withMaxRetries(3).withMinDelay(500L).withMaxDelay(1000L);
        String query = "SELECT ?type (COUNT(?s) AS ?cnt) WHERE {?s a <http://dbpedia.org/ontology/Person> . ?s a ?type .} GROUP BY ?type ORDER BY DESC(?cnt)";
        QueryExecution qe = qef.createQueryExecution(query);
        qe.setTimeout(10000L);
        ResultSet rs = qe.execSelect();
        System.out.println(ResultSetFormatter.asText((ResultSet)rs));
    }
}

