/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorCloseable;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.IClosable;
import org.aksw.jena_sparql_api.core.QueryExecutionAdapter;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.pagination.core.MyQueryIteratorWrapper;
import org.aksw.jena_sparql_api.pagination.core.ResultSetPaginated;
import org.apache.jena.atlas.lib.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionIterated
extends QueryExecutionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionIterated.class);
    private QueryExecutionFactory factory;
    private Iterator<Query> queryIterator;
    private boolean stopOnEmptyResult = true;
    private IClosable currentCloseAction = null;

    public QueryExecutionIterated(QueryExecutionFactory factory, Iterator<Query> queryIterator) {
        this.queryIterator = queryIterator;
        this.factory = factory;
    }

    public QueryExecutionIterated(QueryExecutionFactory factory, Iterator<Query> queryIterator, boolean stopOnEmptyResult) {
        this.queryIterator = queryIterator;
        this.factory = factory;
        this.stopOnEmptyResult = stopOnEmptyResult;
    }

    @Override
    public boolean execAsk() {
        Query query = this.queryIterator.next();
        query.setLimit(Long.MIN_VALUE);
        QueryExecution qe = this.factory.createQueryExecution(query);
        boolean result = qe.execAsk();
        return result;
    }

    @Override
    public ResultSet execSelect() {
        ResultSetPaginated it = new ResultSetPaginated(this.factory, this.queryIterator, this.stopOnEmptyResult);
        it.hasNext();
        ResultSet tmp = it.getCurrentResultSet();
        if (tmp == null) {
            throw new RuntimeException("Underlying result set not avaliable - probably a query failed.");
        }
        List resultVars = tmp.getResultVars();
        MyQueryIteratorWrapper myQueryIterator = new MyQueryIteratorWrapper((Iterator<Binding>)((Object)it));
        QueryIteratorCloseable itClosable = new QueryIteratorCloseable((QueryIterator)myQueryIterator, (Closeable)it);
        ResultSet rs = ResultSetFactory.create((QueryIterator)itClosable, (List)resultVars);
        return rs;
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execConstruct(Model result) {
        try {
            while (this.queryIterator.hasNext()) {
                Query query = this.queryIterator.next();
                final QueryExecution current = this.factory.createQueryExecution(query);
                this.currentCloseAction = new IClosable(){

                    public void close() {
                        current.close();
                    }
                };
                logger.trace("Executing query: " + query);
                Model tmp = current.execConstruct();
                if (!tmp.isEmpty() || !this.stopOnEmptyResult) {
                    result.add(tmp);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public void close() {
        if (this.currentCloseAction != null) {
            this.currentCloseAction.close();
        }
    }
}

