/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Iterables;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_OneOf;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.ResultSetPart;
import org.aksw.jena_sparql_api.utils.ElementUtils;

public class LookupServiceSparqlQuery
implements LookupService<Node, ResultSetPart> {
    private QueryExecutionFactory sparqlService;
    private Query query;
    private Var var;

    public LookupServiceSparqlQuery(QueryExecutionFactory sparqlService, Query query, Var var) {
        this.sparqlService = sparqlService;
        this.query = query;
        this.var = var;
    }

    @Override
    public Map<Node, ResultSetPart> lookup(Iterable<Node> keys) {
        System.out.println("Lookup Request with " + Iterables.size(keys) + " keys: " + keys);
        HashMap<Node, ResultSetPart> result = new HashMap<Node, ResultSetPart>();
        if (Iterables.isEmpty(keys)) {
            return result;
        }
        ExprList exprs = new ExprList();
        for (Node key : keys) {
            NodeValue e = NodeValue.makeNode((Node)key);
            exprs.add((Expr)e);
        }
        E_OneOf expr = new E_OneOf((Expr)new ExprVar(this.var), exprs);
        ElementFilter filterElement = new ElementFilter((Expr)expr);
        Query q = this.query.cloneQuery();
        Element newElement = ElementUtils.mergeElements((Element)q.getQueryPattern(), (Element)filterElement);
        q.setQueryPattern(newElement);
        System.out.println("Lookup query: " + q);
        QueryExecution qe = this.sparqlService.createQueryExecution(q);
        ResultSet rs = qe.execSelect();
        HashMap<Node, ArrayList<Binding>> map = new HashMap<Node, ArrayList<Binding>>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node key = binding.get(this.var);
            ArrayList<Binding> x = (ArrayList<Binding>)map.get(key);
            if (x == null) {
                x = new ArrayList<Binding>();
                map.put(key, x);
            }
            x.add(binding);
        }
        for (Map.Entry entry : map.entrySet()) {
            ResultSetPart rsp = new ResultSetPart((List)entry.getValue(), rs.getResultVars());
            result.put((Node)entry.getKey(), rsp);
        }
        return result;
    }
}

