/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.aksw.commons.collections.IClosable;
import org.aksw.commons.util.StreamUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.core.ResultSetClosable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheResourceCacheEntry
implements CacheResource {
    private static Logger logger = LoggerFactory.getLogger(CacheResourceCacheEntry.class);
    private CacheEntry cacheEntry;

    public CacheResourceCacheEntry(CacheEntry cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    @Override
    public ResultSet asResultSet() {
        try {
            return this._asResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ResultSet _asResultSet() throws SQLException {
        final InputStream in = this.cacheEntry.getInputStream();
        ResultSet resultSet = ResultSetFactory.fromXML((InputStream)in);
        IClosable closable = new IClosable(){

            public void close() {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("Error", (Throwable)e);
                }
            }
        };
        ResultSetClosable result = new ResultSetClosable(resultSet, closable);
        return result;
    }

    @Override
    public boolean isOutdated() {
        return System.currentTimeMillis() - this.cacheEntry.getTimestamp() > this.cacheEntry.getLifespan();
    }

    @Override
    public Model asModel(Model result) {
        try {
            return this._asModel(result);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Model _asModel(Model result) throws SQLException {
        InputStream in = this.cacheEntry.getInputStream();
        result.read(in, null, "N-TRIPLES");
        this.close();
        return result;
    }

    @Override
    public boolean asBoolean() {
        try {
            return this._asBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean _asBoolean() throws SQLException, IOException {
        String str = StreamUtils.toString((InputStream)this.cacheEntry.getInputStream());
        boolean result = Boolean.parseBoolean(str);
        return result;
    }

    public void close() {
        try {
            this.cacheEntry.getInputStream().close();
        }
        catch (IOException e) {
            logger.warn("Error", (Throwable)e);
        }
    }
}

