/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceReference;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.fallback.QueryExecutionFactoryFallback;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.limit.QueryExecutionFactoryLimit;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jena_sparql_api.retry.core.QueryExecutionFactoryRetry;

public class SparqlServiceBuilder {
    private QueryExecutionFactory qef;

    public SparqlServiceBuilder(QueryExecutionFactory qef) {
        this.qef = qef;
    }

    public static SparqlServiceBuilder model(Model model) {
        return new SparqlServiceBuilder(new QueryExecutionFactoryModel(model));
    }

    public static SparqlServiceBuilder http(String service, String ... defaultGraphs) {
        return SparqlServiceBuilder.http(service, Arrays.asList(defaultGraphs));
    }

    public static SparqlServiceBuilder http(String service, Collection<String> defaultGraphs) {
        return new SparqlServiceBuilder(new QueryExecutionFactoryHttp(service, defaultGraphs));
    }

    public static SparqlServiceBuilder http(SparqlServiceReference sparqlService) {
        return SparqlServiceBuilder.http(sparqlService.getServiceURL(), sparqlService.getDefaultGraphURIs());
    }

    public static SparqlServiceBuilder http(Collection<SparqlServiceReference> sparqlServices) {
        if (sparqlServices.size() == 1) {
            return SparqlServiceBuilder.http(sparqlServices.iterator().next());
        }
        ArrayList<QueryExecutionFactory> decoratees = new ArrayList<QueryExecutionFactory>(sparqlServices.size());
        for (SparqlServiceReference sparqlService : sparqlServices) {
            decoratees.add(new QueryExecutionFactoryHttp(sparqlService.getServiceURL(), sparqlService.getDefaultGraphURIs()));
        }
        return new SparqlServiceBuilder(new QueryExecutionFactoryFallback(decoratees));
    }

    public void withDelay(long delayDuration, TimeUnit delayTimeUnit) {
        this.qef = new QueryExecutionFactoryDelay(this.qef, delayDuration, delayTimeUnit);
    }

    public void withPagination(long pageSize) {
        this.qef = new QueryExecutionFactoryPaginated(this.qef, pageSize);
    }

    public void withRetry(int retryCount, long retryDelayDuration, TimeUnit retryDelayTimeUnit) {
        this.qef = new QueryExecutionFactoryRetry(this.qef, retryCount, retryDelayDuration, retryDelayTimeUnit);
    }

    public void withCache(CacheFrontend cache) {
        this.qef = new QueryExecutionFactoryCacheEx(this.qef, cache);
    }

    public void withDefaultLimit(long limit, boolean doCloneQuery) {
        this.qef = new QueryExecutionFactoryLimit(this.qef, doCloneQuery, limit);
    }

    public QueryExecutionFactory create() {
        return this.qef;
    }
}

