/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.commons.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtils.class);

    public static <T> void executeSetArgs(PreparedStatement stmt, Object ... args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            int index = i + 1;
            Object arg = args[i];
            if (arg instanceof InputStream) {
                InputStream in = (InputStream)arg;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    StreamUtils.copyThenClose((InputStream)in, (OutputStream)out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                byte[] buf = out.toByteArray();
                ByteArrayInputStream in2 = new ByteArrayInputStream(buf);
                stmt.setBinaryStream(index, (InputStream)in2, buf.length);
                continue;
            }
            stmt.setObject(index, arg);
        }
        int n = stmt.getParameterMetaData().getParameterCount();
        for (int i = args.length; i < n; ++i) {
            stmt.setObject(i + 1, null);
        }
    }

    public static <T> T execute(Connection conn, String sql, Class<T> clazz, Object ... args) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        T result = SqlUtils.execute(stmt, clazz, args);
        stmt.close();
        return result;
    }

    public static ResultSet executeCore(Connection conn, String sql, Object ... args) throws SQLException {
        logger.trace("Executing statement '" + sql + "' with args " + Arrays.asList(args));
        PreparedStatement stmt = conn.prepareStatement(sql);
        SqlUtils.executeSetArgs(stmt, args);
        ResultSet result = stmt.executeQuery();
        return result;
    }

    public static ResultSet execute(PreparedStatement stmt, Object ... args) throws SQLException {
        SqlUtils.executeSetArgs(stmt, args);
        ResultSet result = stmt.executeQuery();
        return result;
    }

    public static <T> T execute(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        SqlUtils.executeSetArgs(stmt, args);
        T result = null;
        if (clazz == null || Void.class.equals(clazz)) {
            stmt.execute();
        } else {
            ResultSet rs = stmt.executeQuery();
            result = SqlUtils.single(rs, clazz);
            rs.close();
        }
        return result;
    }

    public static <T> List<T> executeList(Connection conn, String sql, Class<T> clazz, Object ... args) throws SQLException {
        logger.trace("Executing statement '" + sql + "' with args " + Arrays.asList(args));
        PreparedStatement stmt = conn.prepareStatement(sql);
        List<T> result = SqlUtils.executeList(stmt, clazz, args);
        stmt.close();
        return result;
    }

    public static <T> List<T> executeList(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        SqlUtils.executeSetArgs(stmt, args);
        ResultSet rs = stmt.executeQuery();
        List<T> result = SqlUtils.list(rs, clazz);
        return result;
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error("Failed to close connection " + conn, (Throwable)e);
            }
        }
    }

    public static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.error("Failed to close statement " + stmt, (Throwable)e);
            }
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                logger.error("Failed to close result set " + resultSet, (Throwable)e);
            }
        }
    }

    public static <T> T single(ResultSet rs, Class<T> clazz) throws SQLException {
        return SqlUtils.single(rs, clazz, true);
    }

    public static <T> T single(ResultSet rs, Class<T> clazz, boolean bClose) throws SQLException {
        if (rs.getMetaData().getColumnCount() != 1) {
            throw new RuntimeException("only a single column expected");
        }
        Object result = null;
        if (rs.next()) {
            Object o;
            result = o = rs.getObject(1);
            if (rs.next()) {
                throw new RuntimeException("only at most 1 row expected");
            }
        }
        if (bClose) {
            rs.close();
        }
        return (T)result;
    }

    public static <T> List<T> list(ResultSet rs, Class<T> clazz) throws SQLException {
        return SqlUtils.list(rs, clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> list(ResultSet rs, Class<T> clazz, boolean bClose) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            while (rs.next()) {
                Object o;
                Object item = o = rs.getObject(1);
                result.add(item);
            }
        }
        finally {
            if (bClose) {
                rs.close();
            }
        }
        return result;
    }
}

