/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.core;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import org.aksw.jena_sparql_api.cache.core.ModelProvider;
import org.aksw.jena_sparql_api.cache.extra.Cache;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.core.QueryExecutionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCache
extends QueryExecutionDecorator {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCache.class);
    private Cache cache;
    private String queryString;

    public QueryExecutionCache(QueryExecution decoratee, String queryString, Cache cache) {
        super(decoratee);
        this.queryString = queryString;
        this.cache = cache;
    }

    public ResultSet doCacheResultSet() {
        CacheResource resource = this.cache.lookup(this.queryString);
        if (resource == null || resource.isOutdated()) {
            ResultSet rs;
            try {
                rs = this.getDecoratee().execSelect();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    return resource.asResultSet();
                }
                throw new RuntimeException(e);
            }
            logger.trace("Cache write: " + this.queryString);
            this.cache.write(this.queryString, rs);
            resource = this.cache.lookup(this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit: " + this.queryString);
        }
        return resource.asResultSet();
    }

    public Model doCacheModel(Model result, ModelProvider modelProvider) {
        try {
            return this._doCacheModel(result, modelProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Model _doCacheModel(Model result, ModelProvider modelProvider) throws IOException {
        CacheResource resource = this.cache.lookup(this.queryString);
        Model model = ModelFactory.createDefaultModel();
        if (resource == null || resource.isOutdated()) {
            try {
                model = modelProvider.getModel();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    model = resource.asModel(model);
                    result.add(model);
                    return result;
                }
                throw new RuntimeException(e);
            }
            logger.trace("Cache write: " + this.queryString);
            this.cache.write(this.queryString, model);
            resource = this.cache.lookup(this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit: " + this.queryString);
        }
        return resource.asModel(result);
    }

    public boolean doCacheBoolean() {
        CacheResource resource = this.cache.lookup(this.queryString);
        if (resource == null || resource.isOutdated()) {
            boolean ret;
            try {
                ret = this.getDecoratee().execAsk();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    return resource.asBoolean();
                }
                throw new RuntimeException(e);
            }
            logger.trace("Cache write: " + this.queryString);
            this.cache.write(this.queryString, ret);
            resource = this.cache.lookup(this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit: " + this.queryString);
        }
        return resource.asBoolean();
    }

    @Override
    public ResultSet execSelect() {
        return this.doCacheResultSet();
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCache.this.getDecoratee().execConstruct();
            }
        });
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCache.this.getDecoratee().execDescribe();
            }
        });
    }

    @Override
    public boolean execAsk() {
        return this.doCacheBoolean();
    }
}

