/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.io.ByteArrayInputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aksw.commons.collections.IClosable;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheEntryImpl;
import org.aksw.jena_sparql_api.cache.staging.InputStreamClosable;

public class CacheCoreIterator
extends SinglePrefetchIterator<CacheEntryImpl> {
    private ResultSet rs;
    private long timeToLive;
    private IClosable inputStreamCloseAction;

    public CacheCoreIterator(ResultSet rs, IClosable inputStreamCloseAction, long timeToLive) {
        this.rs = rs;
        this.inputStreamCloseAction = inputStreamCloseAction;
        this.timeToLive = timeToLive;
    }

    public static CacheEntryImpl createCacheEntry(ResultSet rs, IClosable closeAction, long timeToLive) throws SQLException {
        byte[] rawQueryHash = rs.getBytes("id");
        String queryHash = StringUtils.bytesToHexString((byte[])rawQueryHash);
        String queryString = rs.getString("query_string");
        String str = rs.getString("data");
        ByteArrayInputStream data = new ByteArrayInputStream(str.getBytes());
        Timestamp timeOfInsertion = rs.getTimestamp("time_of_insertion");
        Timestamp timeOfExpiration = rs.getTimestamp("time_of_expiration");
        CacheEntryImpl result = new CacheEntryImpl(timeOfInsertion.getTime(), timeToLive, new InputStreamClosable(data, closeAction), queryString, queryHash);
        return result;
    }

    protected CacheEntryImpl prefetch() throws Exception {
        if (this.rs.next()) {
            CacheEntryImpl result = CacheCoreIterator.createCacheEntry(this.rs, this.inputStreamCloseAction, this.timeToLive);
            return result;
        }
        return (CacheEntryImpl)this.finish();
    }

    public void close() {
    }
}

