/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.cache.extra.CacheResourceCacheEntry;

public class CacheFrontendImpl
implements CacheFrontend {
    private CacheBackend cacheBackend;

    public CacheFrontendImpl(CacheBackend cacheBackend) {
        this.cacheBackend = cacheBackend;
    }

    @Override
    public void write(String service, String queryString, ResultSet resultSet) {
        try {
            this._write(service, queryString, resultSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, final ResultSet resultSet) throws IOException {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ResultSetFormatter.outputAsXML((OutputStream)out, (ResultSet)resultSet);
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        this.cacheBackend.write(service, queryString, in);
    }

    @Override
    public void write(String service, Query query, ResultSet resultSet) {
        this.write(service, query.toString(), resultSet);
    }

    @Override
    public void write(String service, String queryString, Model model) {
        try {
            this._write(service, queryString, model);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, final Model model) throws IOException {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        new Thread(new Runnable(){

            @Override
            public void run() {
                model.write((OutputStream)out, "N-TRIPLES");
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        this.cacheBackend.write(service, queryString, in);
    }

    @Override
    public void write(String service, Query query, Model model) {
        this.write(service, query.toString(), model);
    }

    @Override
    public CacheResource lookup(String service, String queryString) {
        CacheEntry cacheEntry = this.cacheBackend.lookup(service, queryString);
        return cacheEntry == null ? null : new CacheResourceCacheEntry(cacheEntry);
    }

    @Override
    public CacheResource lookup(String service, Query query) {
        CacheEntry cacheEntry = this.cacheBackend.lookup(service, query.toString());
        return cacheEntry == null ? null : new CacheResourceCacheEntry(cacheEntry);
    }

    @Override
    public void write(String service, String queryString, boolean value) {
        try {
            this._write(service, queryString, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, boolean value) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(String.valueOf(value).getBytes());
        this.cacheBackend.write(service, queryString, in);
    }

    @Override
    public void write(String service, Query query, boolean value) {
        this.write(service, query.toString(), value);
    }
}

