/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.example;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheCoreEx;
import org.aksw.jena_sparql_api.cache.extra.CacheCoreH2;
import org.aksw.jena_sparql_api.cache.extra.CacheExImpl;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;

public class Example {
    public static void main(String[] args) throws Exception {
        QueryExecutionFactory qef = new QueryExecutionFactoryHttp("http://dbpedia.org/sparql", "http://dbpedia.org");
        qef = new QueryExecutionFactoryDelay(qef, 7000L);
        long timeToLive = 86400000L;
        CacheCoreEx cacheBackend = CacheCoreH2.create("sparql", timeToLive, true);
        CacheExImpl cacheFrontend = new CacheExImpl(cacheBackend);
        qef = new QueryExecutionFactoryCacheEx(qef, cacheFrontend);
        qef = new QueryExecutionFactoryPaginated(qef, 900L);
        QueryExecution qe = qef.createQueryExecution("Select ?s { ?s a <http://dbpedia.org/ontology/City> } Limit 5000");
        ResultSet rs = qe.execSelect();
        System.out.println(ResultSetFormatter.asText((ResultSet)rs));
    }
}

