/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.delay.extra;

import org.aksw.jena_sparql_api.delay.extra.Delayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayerBase
implements Delayer {
    private static Logger logger = LoggerFactory.getLogger(DelayerBase.class);

    public abstract long getDelay();

    public abstract long getLastRequestTime();

    public abstract void setLastRequestTime(long var1);

    public synchronized void doDelay() {
        long now = System.currentTimeMillis();
        long remainingDelay = this.getDelay() - (now - this.getLastRequestTime());
        if (remainingDelay > 0L) {
            logger.debug("Delaying by " + remainingDelay + "ms.");
            try {
                Thread.sleep(remainingDelay);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.setLastRequestTime(System.currentTimeMillis());
    }
}

