/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aksw.commons.collections.IClosable;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.ResultSetClosable;
import org.aksw.jena_sparql_api.core.utils.IteratorNQuads;
import org.aksw.jena_sparql_api.core.utils.SinkQuadsToCollection;
import org.apache.jena.atlas.lib.Sink;

public class QueryExecutionUtils {
    public static final Var vg = Var.alloc((String)"g");
    public static final Var vs = Var.alloc((String)"s");
    public static final Var vp = Var.alloc((String)"p");
    public static final Var vo = Var.alloc((String)"o");

    public static Iterator<Quad> createIteratorDumpQuads(QueryExecutionFactory qef) {
        String queryStr = "Select ?g ?s ?p ?o { Graph ?g { ?s ?p ?o } }";
        final QueryExecution qe = qef.createQueryExecution(queryStr);
        ResultSet tmp = qe.execSelect();
        ResultSetClosable rs = new ResultSetClosable(tmp, new IClosable(){

            public void close() {
                qe.close();
            }
        });
        IteratorNQuads result = new IteratorNQuads(rs);
        return result;
    }

    public static void createDumpNQuads(QueryExecutionFactory qef, Sink<Quad> sink) {
        Iterator<Quad> it = QueryExecutionUtils.createIteratorDumpQuads(qef);
        while (it.hasNext()) {
            Quad quad = it.next();
            sink.send((Object)quad);
        }
    }

    public static Set<Quad> createDumpNQuads(QueryExecutionFactory qef) {
        SinkQuadsToCollection<HashSet<Quad>> sink = SinkQuadsToCollection.createSinkHashSet();
        QueryExecutionUtils.createDumpNQuads(qef, sink);
        Set result = sink.getQuads();
        return result;
    }

    public static Iterator<Triple> createIteratorDumpTriples(QueryExecutionFactory qef) {
        String queryStr = "Construct { ?s ?p ?o } { ?s ?p ?o }";
        QueryExecution qe = qef.createQueryExecution(queryStr);
        Iterator result = qe.execConstructTriples();
        return result;
    }
}

