/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.aksw.commons.collections.IClosable;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheEntryImpl;
import org.aksw.jena_sparql_api.cache.extra.SqlUtils;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDao;
import org.aksw.jena_sparql_api.cache.staging.CacheCoreIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBackendDaoPostgres
implements CacheBackendDao {
    private static final Logger logger = LoggerFactory.getLogger(CacheBackendDaoPostgres.class);
    private boolean validateHash = true;
    private String QUERY_LOOKUP = "SELECT * FROM \"sparql_query_cache\" WHERE \"id\" = ? LIMIT 2";
    private String QUERY_INSERT = "INSERT INTO \"sparql_query_cache\"(\"id\", \"query_string\", \"data\", \"time_of_insertion\") VALUES (?, ?, ?, ?)";
    private String QUERY_UPDATE = "UPDATE \"query_cache\" SET \"data\"=?, \"time\" = ? WHERE \"id\" = ?";

    @Override
    public CacheEntryImpl lookup(Connection conn, String service, String queryString) throws SQLException {
        String md5 = StringUtils.md5Hash((String)this.createHashRoot(service, queryString));
        final ResultSet rs = SqlUtils.executeCore(conn, this.QUERY_LOOKUP, md5);
        CacheCoreIterator it = new CacheCoreIterator(rs, new IClosable(){

            public void close() {
                SqlUtils.close(rs);
            }
        });
        CacheEntryImpl result = null;
        if (it.hasNext()) {
            String cachedQueryString;
            result = (CacheEntryImpl)it.next();
            if (this.validateHash && !(cachedQueryString = result.getQueryString()).equals(queryString)) {
                logger.error("HASH-CLASH:\nService: " + service + "\nNew QueryString: " + queryString + "\nOld QueryString: " + cachedQueryString);
                return null;
            }
            if (it.hasNext()) {
                logger.warn("Multiple cache hits found, just one expected.");
            }
        }
        return result;
    }

    @Override
    public void write(Connection conn, String service, String queryString, InputStream in) throws SQLException {
        String md5 = StringUtils.md5Hash((String)this.createHashRoot(service, queryString));
        CacheEntryImpl entry = this.lookup(conn, service, queryString);
        Timestamp timestamp = new Timestamp(new GregorianCalendar().getTimeInMillis());
        if (entry != null) {
            SqlUtils.execute(conn, this.QUERY_UPDATE, Void.class, in, timestamp, md5);
        } else {
            SqlUtils.execute(conn, this.QUERY_INSERT, Void.class, md5, queryString, in, timestamp);
        }
    }

    public String createHashRoot(String service, String queryString) {
        return service + " " + queryString;
    }
}

