/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.aksw.commons.collections.IClosable;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheEntryImpl;
import org.aksw.jena_sparql_api.cache.extra.SqlUtils;
import org.aksw.jena_sparql_api.cache.staging.InputStreamProviderBlobClosable;

public class CacheCoreIterator
extends SinglePrefetchIterator<CacheEntryImpl> {
    private ResultSet rs;
    private IClosable inputStreamCloseAction;

    public CacheCoreIterator(ResultSet rs, IClosable inputStreamCloseAction) {
        this.rs = rs;
        this.inputStreamCloseAction = inputStreamCloseAction;
    }

    protected CacheEntryImpl prefetch() throws Exception {
        if (this.rs.next()) {
            byte[] rawQueryHash = this.rs.getBytes("id");
            String queryHash = StringUtils.bytesToHexString((byte[])rawQueryHash);
            String queryString = this.rs.getString("query_string");
            Blob data = this.rs.getBlob("data");
            Timestamp timeOfInsertion = this.rs.getTimestamp("time_of_insertion");
            Timestamp timeOfExpiration = this.rs.getTimestamp("time_of_expiration");
            CacheEntryImpl result = new CacheEntryImpl(timeOfInsertion.getTime(), 1000L, new InputStreamProviderBlobClosable(data, this.inputStreamCloseAction), queryString, queryHash);
            return result;
        }
        return (CacheEntryImpl)this.finish();
    }

    public void close() {
        SqlUtils.close(this.rs);
    }
}

