/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.compare;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.collections.diff.ListDiff;
import org.aksw.commons.collections.diff.ModelDiff;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.compare.QuerySolutionWithEquals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCompare
implements QueryExecution {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCompare.class);
    private boolean isOrdered;
    private QueryExecution a;
    private QueryExecution b;
    private Query query = null;
    private ListDiff<QuerySolution> resultSetDiff = null;
    private ModelDiff modelDiff = null;
    private Diff<Boolean> askDiff = null;

    public static Multiset<QuerySolution> toMultiset(ResultSet rs) {
        HashMultiset result = HashMultiset.create();
        while (rs.hasNext()) {
            QuerySolution original = rs.next();
            QuerySolutionWithEquals wrapped = new QuerySolutionWithEquals(original);
            result.add((Object)wrapped);
        }
        return result;
    }

    public static ListDiff<QuerySolution> compareOrdered(ResultSet a, ResultSet b) {
        ListDiff result = new ListDiff();
        Object x = null;
        QuerySolution y = null;
        while (a.hasNext()) {
            String sy;
            if (!b.hasNext()) {
                while (a.hasNext()) {
                    ((List)result.getAdded()).add(a.next());
                }
                return result;
            }
            if (x == y || x.equals(y)) {
                x = a.next();
                y = b.next();
                continue;
            }
            String sx = x.toString();
            if (sx.compareTo(sy = y.toString()) < 0) {
                ((List)result.getRemoved()).add(x);
                x = a.next();
                continue;
            }
            ((List)result.getAdded()).add(y);
            y = b.next();
        }
        while (b.hasNext()) {
            ((List)result.getRemoved()).add(b.next());
        }
        return result;
    }

    public static ListDiff<QuerySolution> compareUnordered(ResultSet a, ResultSet b) {
        ListDiff result = new ListDiff();
        Multiset<QuerySolution> x = QueryExecutionCompare.toMultiset(a);
        Multiset<QuerySolution> y = QueryExecutionCompare.toMultiset(b);
        HashMultiset common = HashMultiset.create((Iterable)Multisets.intersection(x, y));
        y.removeAll((Collection)common);
        x.removeAll((Collection)common);
        ((List)result.getAdded()).addAll(y);
        ((List)result.getRemoved()).addAll(x);
        return result;
    }

    public static ModelDiff compareModel(Model a, Model b) {
        ModelDiff result = new ModelDiff();
        ((Model)result.getAdded()).add(b);
        ((Model)result.getAdded()).remove(a);
        ((Model)result.getRemoved()).add(a);
        ((Model)result.getRemoved()).remove(b);
        return result;
    }

    public boolean isDifference() {
        if (this.resultSetDiff != null) {
            return !((List)this.resultSetDiff.getAdded()).isEmpty() || !((List)this.resultSetDiff.getRemoved()).isEmpty();
        }
        if (this.modelDiff != null) {
            return !((Model)this.modelDiff.getAdded()).isEmpty() || !((Model)this.modelDiff.getRemoved()).isEmpty();
        }
        if (this.askDiff != null) {
            return this.askDiff.getAdded() != this.askDiff.getRemoved();
        }
        throw new RuntimeException("Cannot retrieve difference because query was not executed.");
    }

    public QueryExecutionCompare(Query query, QueryExecution a, QueryExecution b, boolean isOrdered) {
        this.query = query;
        this.a = a;
        this.b = b;
        this.isOrdered = isOrdered;
    }

    public void setFileManager(FileManager fm) {
    }

    public void setInitialBinding(QuerySolution binding) {
    }

    public Dataset getDataset() {
        return null;
    }

    public Context getContext() {
        return null;
    }

    public Query getQuery() {
        return this.query;
    }

    public ResultSet execSelect() {
        ResultSet y;
        ResultSetRewindable x;
        try {
            x = ResultSetFactory.makeRewindable((ResultSet)this.a.execSelect());
            y = this.b.execSelect();
        }
        catch (RuntimeException e) {
            this.resultSetDiff = new ListDiff();
            throw e;
        }
        this.resultSetDiff = this.isOrdered ? QueryExecutionCompare.compareOrdered((ResultSet)x, y) : QueryExecutionCompare.compareUnordered((ResultSet)x, y);
        x.reset();
        this.logResultSet();
        return x;
    }

    public void log(long added, long removed) {
        String msg = added + "\t" + removed + "\t" + StringUtils.urlEncode((String)("" + this.query));
        if (added == 0L && removed == 0L) {
            logger.info("[ OK ] " + msg);
        } else {
            logger.warn("[FAIL] " + msg);
        }
    }

    public void logResultSet() {
        this.log(((List)this.resultSetDiff.getAdded()).size(), ((List)this.resultSetDiff.getRemoved()).size());
    }

    public void logModel() {
        this.log(((Model)this.modelDiff.getAdded()).size(), ((Model)this.modelDiff.getRemoved()).size());
    }

    public void logAsk() {
        boolean added = (Boolean)this.askDiff.getAdded();
        boolean removed = (Boolean)this.askDiff.getRemoved();
        String msg = added + "\t" + removed + "\t" + StringUtils.urlEncode((String)("" + this.query));
        if (added == removed) {
            logger.trace("[ OK ] " + msg);
        } else {
            logger.warn("[FAIL] " + msg);
        }
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        Model y;
        Model x;
        try {
            x = this.a.execConstruct();
            y = this.b.execConstruct();
        }
        catch (RuntimeException e) {
            this.modelDiff = new ModelDiff();
            throw e;
        }
        this.modelDiff = QueryExecutionCompare.compareModel(x, y);
        this.logModel();
        return x;
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        Model y;
        Model x;
        try {
            x = this.a.execDescribe();
            y = this.b.execDescribe();
        }
        catch (RuntimeException e) {
            this.modelDiff = new ModelDiff();
            throw e;
        }
        this.modelDiff = QueryExecutionCompare.compareModel(x, y);
        this.logModel();
        return x;
    }

    public boolean execAsk() {
        boolean y;
        boolean x;
        try {
            x = this.a.execAsk();
            y = this.b.execAsk();
        }
        catch (RuntimeException e) {
            this.askDiff = new Diff((Object)false, (Object)false, null);
            throw e;
        }
        this.askDiff = new Diff((Object)x, (Object)y, null);
        this.logAsk();
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        try {
            this.a.abort();
        }
        finally {
            this.b.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.a.close();
        }
        finally {
            this.b.close();
        }
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        this.a.setTimeout(timeout, timeoutUnits);
        this.b.setTimeout(timeout, timeoutUnits);
    }

    public void setTimeout(long timeout) {
        this.a.setTimeout(timeout);
        this.b.setTimeout(timeout);
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.a.setTimeout(timeout1, timeUnit1, timeout2, timeUnit2);
        this.b.setTimeout(timeout1, timeUnit1, timeout2, timeUnit2);
    }

    public void setTimeout(long timeout1, long timeout2) {
        this.a.setTimeout(timeout1, timeout2);
        this.b.setTimeout(timeout1, timeout2);
    }

    public Iterator<Triple> execConstructTriples() {
        throw new RuntimeException("Not implemented yet");
    }

    public Iterator<Triple> execDescribeTriples() {
        throw new RuntimeException("Not implemented yet");
    }

    public long getTimeout1() {
        return this.a.getTimeout1();
    }

    public long getTimeout2() {
        return this.a.getTimeout2();
    }
}

