/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecutionFactoryHttp
extends QueryExecutionFactoryBackString {
    private String service;
    private List<String> defaultGraphs = new ArrayList<String>();

    public QueryExecutionFactoryHttp(String service) {
        this(service, Collections.emptySet());
    }

    public QueryExecutionFactoryHttp(String service, String defaultGraphName) {
        this(service, Collections.singleton(defaultGraphName));
    }

    public QueryExecutionFactoryHttp(String service, Collection<String> defaultGraphs) {
        this.service = service;
        this.defaultGraphs = new ArrayList<String>(defaultGraphs);
        Collections.sort(this.defaultGraphs);
    }

    @Override
    public String getId() {
        return this.service;
    }

    @Override
    public String getState() {
        return Joiner.on((String)"|").join(this.defaultGraphs);
    }

    @Override
    public QueryExecution createQueryExecution(String queryString) {
        QueryEngineHTTP result = new QueryEngineHTTP(this.service, queryString);
        result.setDefaultGraphURIs(this.defaultGraphs);
        return result;
    }
}

